﻿using System.Collections.Generic;
using System.Web.Services;
using System.Web.Script.Services;
using System.Web.Script.Serialization;

namespace WebServicesPostToJqGrid
{
    public class jqGridRecord {
        public int ID {get; set;}
        public string Sigla {get; set;}
        public string Name {get; set;}
        public string Region { get; set; }
    }

    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [System.ComponentModel.ToolboxItem(false)]
    [System.Web.Script.Services.ScriptService]
    public class Service1 : System.Web.Services.WebService
    {
        private static string jsonData = "[{\"ID\":1,\"Sigla\":\"AG\",\"Name\":\"Agrigento\",\"Region\":\"Sicilia\"},{\"ID\":2,\"Sigla\":\"AL\",\"Name\":\"Alessandria\",\"Region\":\"Piemonte\"},{\"ID\":3,\"Sigla\":\"AN\",\"Name\":\"Ancona\",\"Region\":\"Lombardia\"},{\"ID\":4,\"Sigla\":\"AO\",\"Name\":\"Aosta\",\"Region\":\"Valle d'Aosta\"},{\"ID\":5,\"Sigla\":\"AR\",\"Name\":\"Arezzo\",\"Region\":\"Toscana\"},{\"ID\":6,\"Sigla\":\"AP\",\"Name\":\"Ascoli Piceno\",\"Region\":\"Lombardia\"},{\"ID\":7,\"Sigla\":\"AT\",\"Name\":\"Asti\",\"Region\":\"Piemonte\"},{\"ID\":8,\"Sigla\":\"AV\",\"Name\":\"Avellino\",\"Region\":\"Campania\"},{\"ID\":9,\"Sigla\":\"BA\",\"Name\":\"Bari\",\"Region\":\"Puglia\"},{\"ID\":10,\"Sigla\":\"BL\",\"Name\":\"Belluno\",\"Region\":\"Veneto\"},{\"ID\":11,\"Sigla\":\"BN\",\"Name\":\"Benevento\",\"Region\":\"Campania\"},{\"ID\":12,\"Sigla\":\"BG\",\"Name\":\"Bergamo\",\"Region\":\"Lombardia\"},{\"ID\":13,\"Sigla\":\"BI\",\"Name\":\"Biella\",\"Region\":\"Piemonte\"},{\"ID\":14,\"Sigla\":\"BO\",\"Name\":\"Bologna\",\"Region\":\"Emilia Romagna\"},{\"ID\":15,\"Sigla\":\"BZ\",\"Name\":\"Bolzano\",\"Region\":\"Trentino Alto Adige\"},{\"ID\":16,\"Sigla\":\"BS\",\"Name\":\"Brescia\",\"Region\":\"Lombardia\"},{\"ID\":17,\"Sigla\":\"BR\",\"Name\":\"Brindisi\",\"Region\":\"Puglia\"},{\"ID\":18,\"Sigla\":\"CA\",\"Name\":\"Cagliari\",\"Region\":\"Sardegna\"},{\"ID\":19,\"Sigla\":\"CL\",\"Name\":\"Caltanissetta\",\"Region\":\"Sicilia\"},{\"ID\":20,\"Sigla\":\"CB\",\"Name\":\"Campobasso\",\"Region\":\"Molise\"},{\"ID\":21,\"Sigla\":\"CI\",\"Name\":\"Carbonia-Iglesias\",\"Region\":\"Sardegna\"},{\"ID\":22,\"Sigla\":\"CE\",\"Name\":\"Caserta\",\"Region\":\"Campania\"},{\"ID\":23,\"Sigla\":\"CT\",\"Name\":\"Catania\",\"Region\":\"Sicilia\"},{\"ID\":24,\"Sigla\":\"CZ\",\"Name\":\"Catanzaro\",\"Region\":\"Calabria\"},{\"ID\":25,\"Sigla\":\"CH\",\"Name\":\"Chieti\",\"Region\":\"Abruzzo\"},{\"ID\":26,\"Sigla\":\"CO\",\"Name\":\"Como\",\"Region\":\"Lombardia\"},{\"ID\":27,\"Sigla\":\"CS\",\"Name\":\"Cosenza\",\"Region\":\"Calabria\"},{\"ID\":28,\"Sigla\":\"CR\",\"Name\":\"Cremona\",\"Region\":\"Lombardia\"},{\"ID\":29,\"Sigla\":\"KR\",\"Name\":\"Crotone\",\"Region\":\"Calabria\"},{\"ID\":30,\"Sigla\":\"CN\",\"Name\":\"Cuneo\",\"Region\":\"Piemonte\"},{\"ID\":31,\"Sigla\":\"EN\",\"Name\":\"Enna\",\"Region\":\"Sicilia\"},{\"ID\":32,\"Sigla\":\"FE\",\"Name\":\"Ferrara\",\"Region\":\"Emilia Romagna\"},{\"ID\":33,\"Sigla\":\"FI\",\"Name\":\"Firenze\",\"Region\":\"Toscana\"},{\"ID\":34,\"Sigla\":\"FG\",\"Name\":\"Foggia\",\"Region\":\"Puglia\"},{\"ID\":35,\"Sigla\":\"FC\",\"Name\":\"Forli-Cesena\",\"Region\":\"Emilia Romagna\"},{\"ID\":36,\"Sigla\":\"FR\",\"Name\":\"Frosinone\",\"Region\":\"Lazio\"},{\"ID\":37,\"Sigla\":\"GE\",\"Name\":\"Genova\",\"Region\":\"Liguria\"},{\"ID\":38,\"Sigla\":\"GO\",\"Name\":\"Gorizia\",\"Region\":\"Friuli Venezia Giulia\"},{\"ID\":39,\"Sigla\":\"GR\",\"Name\":\"Grosseto\",\"Region\":\"Toscana\"},{\"ID\":40,\"Sigla\":\"IM\",\"Name\":\"Imperia\",\"Region\":\"Liguria\"},{\"ID\":41,\"Sigla\":\"IS\",\"Name\":\"Isernia\",\"Region\":\"Molise\"},{\"ID\":42,\"Sigla\":\"SP\",\"Name\":\"La Spezia\",\"Region\":\"Liguria\"},{\"ID\":43,\"Sigla\":\"AQ\",\"Name\":\"L'Aquila\",\"Region\":\"Abruzzo\"},{\"ID\":44,\"Sigla\":\"LT\",\"Name\":\"Latina\",\"Region\":\"Lazio\"},{\"ID\":45,\"Sigla\":\"LE\",\"Name\":\"Lecce\",\"Region\":\"Puglia\"},{\"ID\":46,\"Sigla\":\"LC\",\"Name\":\"Lecco\",\"Region\":\"Lombardia\"},{\"ID\":47,\"Sigla\":\"LI\",\"Name\":\"Livorno\",\"Region\":\"Toscana\"},{\"ID\":48,\"Sigla\":\"LO\",\"Name\":\"Lodi\",\"Region\":\"Lombardia\"},{\"ID\":49,\"Sigla\":\"LU\",\"Name\":\"Lucca\",\"Region\":\"Toscana\"},{\"ID\":50,\"Sigla\":\"MC\",\"Name\":\"Macerata\",\"Region\":\"Lombardia\"},{\"ID\":51,\"Sigla\":\"MN\",\"Name\":\"Mantova\",\"Region\":\"Lombardia\"},{\"ID\":52,\"Sigla\":\"MS\",\"Name\":\"Massa-Carrara\",\"Region\":\"Toscana\"},{\"ID\":53,\"Sigla\":\"MT\",\"Name\":\"Matera\",\"Region\":\"Basilicata\"},{\"ID\":54,\"Sigla\":\"ME\",\"Name\":\"Messina\",\"Region\":\"Sicilia\"},{\"ID\":55,\"Sigla\":\"MI\",\"Name\":\"Milano\",\"Region\":\"Lombardia\"},{\"ID\":56,\"Sigla\":\"MO\",\"Name\":\"Modena\",\"Region\":\"Emilia Romagna\"},{\"ID\":57,\"Sigla\":\"NA\",\"Name\":\"Napoli\",\"Region\":\"Campania\"},{\"ID\":58,\"Sigla\":\"NO\",\"Name\":\"Novara\",\"Region\":\"Piemonte\"},{\"ID\":59,\"Sigla\":\"NU\",\"Name\":\"Nuoro\",\"Region\":\"Sardegna\"},{\"ID\":60,\"Sigla\":\"OT\",\"Name\":\"Olbia-Tempio\",\"Region\":\"Sardegna\"},{\"ID\":61,\"Sigla\":\"OR\",\"Name\":\"Oristano\",\"Region\":\"Sardegna\"},{\"ID\":62,\"Sigla\":\"PD\",\"Name\":\"Padova\",\"Region\":\"Veneto\"},{\"ID\":63,\"Sigla\":\"PA\",\"Name\":\"Palermo\",\"Region\":\"Sicilia\"},{\"ID\":64,\"Sigla\":\"PR\",\"Name\":\"Parma\",\"Region\":\"Emilia Romagna\"},{\"ID\":65,\"Sigla\":\"PV\",\"Name\":\"Pavia\",\"Region\":\"Lombardia\"},{\"ID\":66,\"Sigla\":\"PG\",\"Name\":\"Perugia\",\"Region\":\"Umbria\"},{\"ID\":67,\"Sigla\":\"PU\",\"Name\":\"Pesaro e Urbino\",\"Region\":\"Lombardia\"},{\"ID\":68,\"Sigla\":\"PE\",\"Name\":\"Pescara\",\"Region\":\"Abruzzo\"},{\"ID\":69,\"Sigla\":\"PC\",\"Name\":\"Piacenza\",\"Region\":\"Emilia Romagna\"},{\"ID\":70,\"Sigla\":\"PI\",\"Name\":\"Pisa\",\"Region\":\"Toscana\"},{\"ID\":71,\"Sigla\":\"PT\",\"Name\":\"Pistoia\",\"Region\":\"Toscana\"},{\"ID\":72,\"Sigla\":\"PN\",\"Name\":\"Pordenone\",\"Region\":\"Friuli Venezia Giulia\"},{\"ID\":73,\"Sigla\":\"PZ\",\"Name\":\"Potenza\",\"Region\":\"Basilicata\"},{\"ID\":74,\"Sigla\":\"PO\",\"Name\":\"Prato\",\"Region\":\"Toscana\"},{\"ID\":75,\"Sigla\":\"RG\",\"Name\":\"Ragusa\",\"Region\":\"Sicilia\"},{\"ID\":76,\"Sigla\":\"RA\",\"Name\":\"Ravenna\",\"Region\":\"Emilia Romagna\"},{\"ID\":77,\"Sigla\":\"RC\",\"Name\":\"Reggio Calabria\",\"Region\":\"Calabria\"},{\"ID\":78,\"Sigla\":\"RE\",\"Name\":\"Reggio Emilia\",\"Region\":\"Emilia Romagna\"},{\"ID\":79,\"Sigla\":\"RI\",\"Name\":\"Rieti\",\"Region\":\"Lazio\"},{\"ID\":80,\"Sigla\":\"RN\",\"Name\":\"Rimini\",\"Region\":\"Emilia Romagna\"},{\"ID\":81,\"Sigla\":\"RM\",\"Name\":\"Roma\",\"Region\":\"Lazio\"},{\"ID\":82,\"Sigla\":\"RO\",\"Name\":\"Rovigo\",\"Region\":\"Veneto\"},{\"ID\":83,\"Sigla\":\"SA\",\"Name\":\"Salerno\",\"Region\":\"Campania\"},{\"ID\":84,\"Sigla\":\"VS\",\"Name\":\"Medio Campidano\",\"Region\":\"Sardegna\"},{\"ID\":85,\"Sigla\":\"SS\",\"Name\":\"Sassari\",\"Region\":\"Sardegna\"},{\"ID\":86,\"Sigla\":\"SV\",\"Name\":\"Savona\",\"Region\":\"Liguria\"},{\"ID\":87,\"Sigla\":\"SI\",\"Name\":\"Siena\",\"Region\":\"Toscana\"},{\"ID\":88,\"Sigla\":\"SR\",\"Name\":\"Siracusa\",\"Region\":\"Sicilia\"},{\"ID\":89,\"Sigla\":\"SO\",\"Name\":\"Sondrio\",\"Region\":\"Lombardia\"},{\"ID\":90,\"Sigla\":\"TA\",\"Name\":\"Taranto\",\"Region\":\"Puglia\"},{\"ID\":91,\"Sigla\":\"TE\",\"Name\":\"Teramo\",\"Region\":\"Abruzzo\"},{\"ID\":92,\"Sigla\":\"TR\",\"Name\":\"Terni\",\"Region\":\"Umbria\"},{\"ID\":93,\"Sigla\":\"TO\",\"Name\":\"Torino\",\"Region\":\"Piemonte\"},{\"ID\":94,\"Sigla\":\"OG\",\"Name\":\"Ogliastra\",\"Region\":\"Sardegna\"},{\"ID\":95,\"Sigla\":\"TP\",\"Name\":\"Trapani\",\"Region\":\"Sicilia\"},{\"ID\":96,\"Sigla\":\"TN\",\"Name\":\"Trento\",\"Region\":\"Trentino Alto Adige\"},{\"ID\":97,\"Sigla\":\"TV\",\"Name\":\"Treviso\",\"Region\":\"Veneto\"},{\"ID\":98,\"Sigla\":\"TS\",\"Name\":\"Trieste\",\"Region\":\"Friuli Venezia Giulia\"},{\"ID\":99,\"Sigla\":\"UD\",\"Name\":\"Udine\",\"Region\":\"Friuli Venezia Giulia\"},{\"ID\":100,\"Sigla\":\"VA\",\"Name\":\"Varese\",\"Region\":\"Lombardia\"},{\"ID\":101,\"Sigla\":\"VE\",\"Name\":\"Venezia\",\"Region\":\"Veneto\"},{\"ID\":102,\"Sigla\":\"VB\",\"Name\":\"Verbano-Cusio-Ossola\",\"Region\":\"Piemonte\"},{\"ID\":103,\"Sigla\":\"VC\",\"Name\":\"Vercelli\",\"Region\":\"Piemonte\"},{\"ID\":104,\"Sigla\":\"VR\",\"Name\":\"Verona\",\"Region\":\"Veneto\"},{\"ID\":105,\"Sigla\":\"VV\",\"Name\":\"Vibo Valentia\",\"Region\":\"Calabria\"},{\"ID\":106,\"Sigla\":\"VI\",\"Name\":\"Vicenza\",\"Region\":\"Veneto\"},{\"ID\":107,\"Sigla\":\"VT\",\"Name\":\"Viterbo\",\"Region\":\"Lazio\"}]";
        [WebMethod, ScriptMethod(ResponseFormat = ResponseFormat.Json)]
        // if one want use client side searching the method can has no parameters
        // and give all data at once back
        //public JqGridData GetProvinces () {
        public JqGridData GetProvinces (int page, int rows, string sidx, string sord,
            bool _search) {
            //bool _search, string searchField, string searchOper, string searchString) {
            //bool _search, string filters) {
            // for advance search use "string filters" instead of last three parameters
            // for simple search use "string searchField, string searchOper, string searchString"

            //if (_search && !string.IsNullOrEmpty (filters)) {
            //    JavaScriptSerializer serializer = new JavaScriptSerializer ();
            //    jqGridSearchFilter searchFilter = serializer.Deserialize<jqGridSearchFilter> (filters);
            //}
            JavaScriptSerializer ser = new JavaScriptSerializer ();
            List<jqGridRecord> data = ser.Deserialize<List<jqGridRecord>> (jsonData);



            int recordsCount = data.Count;

            int startIndex = (page - 1) * rows;
            int endIndex = (startIndex + rows < recordsCount) ? startIndex + rows : recordsCount;
            List<jqGridRecord> gridRows = new List<jqGridRecord> (rows);
            for (int i = startIndex; i < endIndex; i++)
                gridRows.Add (data[i]);

            return new JqGridData() {
                total = (recordsCount + rows - 1) / rows,
                page = page,
                records = recordsCount,
                rows = gridRows
            };
        }

        public class JqGridData {
            public int total { get; set; }
            public int page { get; set; }
            public int records { get; set; }
            public List<jqGridRecord> rows { get; set; }
        }

        public class jqGridSearchFilterItem {
            public string field { get; set; }
            public string op { get; set; }
            public string data { get; set; }
        }
        public class jqGridSearchFilter {
            public string groupOp { get; set; }
            public List<jqGridSearchFilterItem> rules { get; set; }
        }
    }
}
