unit PartsAndStates;

interface

uses SysUtils, Windows, UxTheme;

type
  IntegerArray = array of integer;
  StringArray = array of string;

const
  CLS_HOT = 2;
  CLS_PRESSED = 3;
  GP_BORDER = 1;
  GP_LINEHORZ = 2;
  GP_LINEVERT = 3;
  BSS_FLAT = 1;
  BSS_RAISED = 2;
  BSS_SUNKEN = 3;
  LHS_FLAT = 1;
  LHS_RAISED = 2;
  LHS_SUNKEN = 3;
  LVS_FLAT = 1;
  LVS_RAISED = 2;
  LVS_SUNKEN = 3;
  LISS_DISABLED = 4;
  LISS_HOT = 2;
  LISS_NORMAL = 1;
  LISS_SELECTED = 3;
  LISS_SELECTEDNOTFOCUS = 5;
  SEBP_SEARCHEDITBOXTEXT = 1; {?}
  SEBTS_FORMATTED = 1; {?}
  TBP_SIZINGBARBOTTOMLEFT = 8; {?}
  TP_DROPDOWNBUTTONGLYPH = 7;
  TTP_WRENCH = 7;
  TTWS_NORMAL = 1;
  TTWS_HOT = 2;
  TTWS_PRESSED = 3;

type
  TConstInfo = record
    Ident: string;
    Value: integer;
  end;

const
  ConstantDirectory: array[0..977] of TConstInfo =
      ((Ident: 'BP_CHECKBOX'; Value: BP_CHECKBOX),
       (Ident: 'CBS_CHECKEDDISABLED'; Value: CBS_CHECKEDDISABLED),
       (Ident: 'CBS_CHECKEDHOT'; Value: CBS_CHECKEDHOT),
       (Ident: 'CBS_CHECKEDNORMAL'; Value: CBS_CHECKEDNORMAL),
       (Ident: 'CBS_CHECKEDPRESSED'; Value: CBS_CHECKEDPRESSED),
       (Ident: 'CBS_MIXEDDISABLED'; Value: CBS_MIXEDDISABLED),
       (Ident: 'CBS_MIXEDHOT'; Value: CBS_MIXEDHOT),
       (Ident: 'CBS_MIXEDNORMAL'; Value: CBS_MIXEDNORMAL),
       (Ident: 'CBS_MIXEDPRESSED'; Value: CBS_MIXEDPRESSED),
       (Ident: 'CBS_UNCHECKEDDISABLED'; Value: CBS_UNCHECKEDDISABLED),
       (Ident: 'CBS_UNCHECKEDHOT'; Value: CBS_UNCHECKEDHOT),
       (Ident: 'CBS_UNCHECKEDNORMAL'; Value: CBS_UNCHECKEDNORMAL),
       (Ident: 'CBS_UNCHECKEDPRESSED'; Value: CBS_UNCHECKEDPRESSED),
       (Ident: 'BP_COMMANDLINK'; Value: BP_COMMANDLINK),
       (Ident: 'CMDLS_DEFAULTED'; Value: CMDLS_DEFAULTED),
       (Ident: 'CMDLS_DEFAULTED_ANIMATING'; Value: CMDLS_DEFAULTED_ANIMATING),
       (Ident: 'CMDLS_DISABLED'; Value: CMDLS_DISABLED),
       (Ident: 'CMDLS_HOT'; Value: CMDLS_HOT),
       (Ident: 'CMDLS_NORMAL'; Value: CMDLS_NORMAL),
       (Ident: 'CMDLS_PRESSED'; Value: CMDLS_PRESSED),
       (Ident: 'BP_COMMANDLINKGLYPH'; Value: BP_COMMANDLINKGLYPH),
       (Ident: 'CMDLGS_DEFAULTED'; Value: CMDLGS_DEFAULTED),
       (Ident: 'CMDLGS_DISABLED'; Value: CMDLGS_DISABLED),
       (Ident: 'CMDLGS_HOT'; Value: CMDLGS_HOT),
       (Ident: 'CMDLGS_NORMAL'; Value: CMDLGS_NORMAL),
       (Ident: 'CMDLGS_PRESSED'; Value: CMDLGS_PRESSED),
       (Ident: 'BP_GROUPBOX'; Value: BP_GROUPBOX),
       (Ident: 'GBS_DISABLED'; Value: GBS_DISABLED),
       (Ident: 'GBS_NORMAL'; Value: GBS_NORMAL),
       (Ident: 'BP_PUSHBUTTON'; Value: BP_PUSHBUTTON),
       (Ident: 'PBS_DEFAULTED'; Value: PBS_DEFAULTED),
       (Ident: 'PBS_DISABLED'; Value: PBS_DISABLED),
       (Ident: 'PBS_HOT'; Value: PBS_HOT),
       (Ident: 'PBS_NORMAL'; Value: PBS_NORMAL),
       (Ident: 'PBS_PRESSED'; Value: PBS_PRESSED),
       (Ident: 'BP_RADIOBUTTON'; Value: BP_RADIOBUTTON),
       (Ident: 'RBS_CHECKEDDISABLED'; Value: RBS_CHECKEDDISABLED),
       (Ident: 'RBS_CHECKEDHOT'; Value: RBS_CHECKEDHOT),
       (Ident: 'RBS_CHECKEDNORMAL'; Value: RBS_CHECKEDNORMAL),
       (Ident: 'RBS_CHECKEDPRESSED'; Value: RBS_CHECKEDPRESSED),
       (Ident: 'RBS_UNCHECKEDDISABLED'; Value: RBS_UNCHECKEDDISABLED),
       (Ident: 'RBS_UNCHECKEDHOT'; Value: RBS_UNCHECKEDHOT),
       (Ident: 'RBS_UNCHECKEDNORMAL'; Value: RBS_UNCHECKEDNORMAL),
       (Ident: 'RBS_UNCHECKEDPRESSED'; Value: RBS_UNCHECKEDPRESSED),
       (Ident: 'BP_USERBUTTON'; Value: BP_USERBUTTON),
       (Ident: 'CLP_TIME'; Value: CLP_TIME),
       (Ident: 'CLS_NORMAL'; Value: CLS_NORMAL),
       (Ident: 'CLS_HOT'; Value: CLS_HOT),
       (Ident: 'CLS_PRESSED'; Value: CLS_PRESSED),
       (Ident: 'CP_BACKGROUND'; Value: CP_BACKGROUND),
       (Ident: 'CP_BORDER'; Value: CP_BORDER),
       (Ident: 'CBB_DISABLED'; Value: CBB_DISABLED),
       (Ident: 'CBB_FOCUSED'; Value: CBB_FOCUSED),
       (Ident: 'CBB_HOT'; Value: CBB_HOT),
       (Ident: 'CBB_NORMAL'; Value: CBB_NORMAL),
       (Ident: 'CP_CUEBANNER'; Value: CP_CUEBANNER),
       (Ident: 'CBCB_DISABLED'; Value: CBCB_DISABLED),
       (Ident: 'CBCB_HOT'; Value: CBCB_HOT),
       (Ident: 'CBCB_NORMAL'; Value: CBCB_NORMAL),
       (Ident: 'CBCB_PRESSED'; Value: CBCB_PRESSED),
       (Ident: 'CP_DROPDOWNBUTTON'; Value: CP_DROPDOWNBUTTON),
       (Ident: 'CBXS_DISABLED'; Value: CBXS_DISABLED),
       (Ident: 'CBXS_HOT'; Value: CBXS_HOT),
       (Ident: 'CBXS_NORMAL'; Value: CBXS_NORMAL),
       (Ident: 'CBXS_PRESSED'; Value: CBXS_PRESSED),
       (Ident: 'CP_DROPDOWNBUTTONLEFT'; Value: CP_DROPDOWNBUTTONLEFT),
       (Ident: 'CBXSL_DISABLED'; Value: CBXSL_DISABLED),
       (Ident: 'CBXSL_HOT'; Value: CBXSL_HOT),
       (Ident: 'CBXSL_NORMAL'; Value: CBXSL_NORMAL),
       (Ident: 'CBXSL_PRESSED'; Value: CBXSL_PRESSED),
       (Ident: 'CP_DROPDOWNBUTTONRIGHT'; Value: CP_DROPDOWNBUTTONRIGHT),
       (Ident: 'CBXSR_DISABLED'; Value: CBXSR_DISABLED),
       (Ident: 'CBXSR_HOT'; Value: CBXSR_HOT),
       (Ident: 'CBXSR_NORMAL'; Value: CBXSR_NORMAL),
       (Ident: 'CBXSR_PRESSED'; Value: CBXSR_PRESSED),
       (Ident: 'CP_TRANSPARENTBACKGROUND'; Value: CP_TRANSPARENTBACKGROUND),
       (Ident: 'CBTBS_DISABLED'; Value: CBTBS_DISABLED),
       (Ident: 'CBTBS_FOCUSED'; Value: CBTBS_FOCUSED),
       (Ident: 'CBTBS_HOT'; Value: CBTBS_HOT),
       (Ident: 'CBTBS_NORMAL'; Value: CBTBS_NORMAL),
       (Ident: 'CP_READONLY'; Value: CP_READONLY),
       (Ident: 'CBRO_DISABLED'; Value: CBRO_DISABLED),
       (Ident: 'CBRO_HOT'; Value: CBRO_HOT),
       (Ident: 'CBRO_NORMAL'; Value: CBRO_NORMAL),
       (Ident: 'CBRO_PRESSED'; Value: CBRO_PRESSED),
       (Ident: 'CSST_TAB'; Value: CSST_TAB),
       (Ident: 'CSTB_HOT'; Value: CSTB_HOT),
       (Ident: 'CSTB_NORMAL'; Value: CSTB_NORMAL),
       (Ident: 'CSTB_SELECTED'; Value: CSTB_SELECTED),
       (Ident: 'CPANEL_BANNERAREA'; Value: CPANEL_BANNERAREA),
       (Ident: 'CPANEL_BODYTEXT'; Value: CPANEL_BODYTEXT),
       (Ident: 'CPANEL_BODYTITLE'; Value: CPANEL_BODYTITLE),
       (Ident: 'CPANEL_BUTTON'; Value: CPANEL_BUTTON),
       (Ident: 'CPANEL_CONTENTLINK'; Value: CPANEL_CONTENTLINK),
       (Ident: 'CPCL_DISABLED'; Value: CPCL_DISABLED),
       (Ident: 'CPCL_HOT'; Value: CPCL_HOT),
       (Ident: 'CPCL_NORMAL'; Value: CPCL_NORMAL),
       (Ident: 'CPCL_PRESSED'; Value: CPCL_PRESSED),
       (Ident: 'CPANEL_CONTENTPANE'; Value: CPANEL_CONTENTPANE),
       (Ident: 'CPANEL_CONTENTPANELABEL'; Value: CPANEL_CONTENTPANELABEL),
       (Ident: 'CPANEL_CONTENTPANELINE'; Value: CPANEL_CONTENTPANELINE),
       (Ident: 'CPANEL_GROUPTEXT'; Value: CPANEL_GROUPTEXT),
       (Ident: 'CPANEL_HELPLINK'; Value: CPANEL_HELPLINK),
       (Ident: 'CPHL_DISABLED'; Value: CPHL_DISABLED),
       (Ident: 'CPHL_HOT'; Value: CPHL_HOT),
       (Ident: 'CPHL_NORMAL'; Value: CPHL_NORMAL),
       (Ident: 'CPHL_PRESSED'; Value: CPHL_PRESSED),
       (Ident: 'CPANEL_LARGECOMMANDAREA'; Value: CPANEL_LARGECOMMANDAREA),
       (Ident: 'CPANEL_MESSAGETEXT'; Value: CPANEL_MESSAGETEXT),
       (Ident: 'CPANEL_NAVIGATIONPANE'; Value: CPANEL_NAVIGATIONPANE),
       (Ident: 'CPANEL_NAVIGATIONPANELABEL'; Value: CPANEL_NAVIGATIONPANELABEL),
       (Ident: 'CPANEL_NAVIGATIONPANELINE'; Value: CPANEL_NAVIGATIONPANELINE),
       (Ident: 'CPANEL_SECTIONTITLELINK'; Value: CPANEL_SECTIONTITLELINK),
       (Ident: 'CPSTL_HOT'; Value: CPSTL_HOT),
       (Ident: 'CPSTL_NORMAL'; Value: CPSTL_NORMAL),
       (Ident: 'CPANEL_SMALLCOMMANDAREA'; Value: CPANEL_SMALLCOMMANDAREA),
       (Ident: 'CPANEL_TASKLINK'; Value: CPANEL_TASKLINK),
       (Ident: 'CPTL_DISABLED'; Value: CPTL_DISABLED),
       (Ident: 'CPTL_HOT'; Value: CPTL_HOT),
       (Ident: 'CPTL_NORMAL'; Value: CPTL_NORMAL),
       (Ident: 'CPTL_PAGE'; Value: CPTL_PAGE),
       (Ident: 'CPTL_PRESSED'; Value: CPTL_PRESSED),
       (Ident: 'CPANEL_TITLE'; Value: CPANEL_TITLE),
       (Ident: 'DP_DATEBORDER'; Value: DP_DATEBORDER),
       (Ident: 'DPDB_DISABLED'; Value: DPDB_DISABLED),
       (Ident: 'DPDB_FOCUSED'; Value: DPDB_FOCUSED),
       (Ident: 'DPDB_HOT'; Value: DPDB_HOT),
       (Ident: 'DPDB_NORMAL'; Value: DPDB_NORMAL),
       (Ident: 'DP_DATETEXT'; Value: DP_DATETEXT),
       (Ident: 'DPDT_DISABLED'; Value: DPDT_DISABLED),
       (Ident: 'DPDT_NORMAL'; Value: DPDT_NORMAL),
       (Ident: 'DPDT_SELECTED'; Value: DPDT_SELECTED),
       (Ident: 'DP_SHOWCALENDARBUTTONRIGHT'; Value: DP_SHOWCALENDARBUTTONRIGHT),
       (Ident: 'DPSCBR_DISABLED'; Value: DPSCBR_DISABLED),
       (Ident: 'DPSCBR_HOT'; Value: DPSCBR_HOT),
       (Ident: 'DPSCBR_NORMAL'; Value: DPSCBR_NORMAL),
       (Ident: 'DPSCBR_PRESSED'; Value: DPSCBR_PRESSED),
       (Ident: 'DD_COPY'; Value: DD_COPY),
       (Ident: 'DDCOPY_HIGHLIGHT'; Value: DDCOPY_HIGHLIGHT),
       (Ident: 'DDCOPY_NOHIGHLIGHT'; Value: DDCOPY_NOHIGHLIGHT),
       (Ident: 'DD_CREATELINK'; Value: DD_CREATELINK),
       (Ident: 'DDCREATELINK_HIGHLIGHT'; Value: DDCREATELINK_HIGHLIGHT),
       (Ident: 'DDCREATELINK_NOHIGHLIGHT'; Value: DDCREATELINK_NOHIGHLIGHT),
       (Ident: 'DD_IMAGEBG'; Value: DD_IMAGEBG),
       (Ident: 'DD_MOVE'; Value: DD_MOVE),
       (Ident: 'DDMOVE_HIGHLIGHT'; Value: DDMOVE_HIGHLIGHT),
       (Ident: 'DDMOVE_NOHIGHLIGHT'; Value: DDMOVE_NOHIGHLIGHT),
       (Ident: 'DD_NONE'; Value: DD_NONE),
       (Ident: 'DDNONE_HIGHLIGHT'; Value: DDNONE_HIGHLIGHT),
       (Ident: 'DDNONE_NOHIGHLIGHT'; Value: DDNONE_NOHIGHLIGHT),
       (Ident: 'DD_TEXTBG'; Value: DD_TEXTBG),
       (Ident: 'DD_UPDATEMETADATA'; Value: DD_UPDATEMETADATA),
       (Ident: 'DDUPDATEMETADATA_HIGHLIGHT'; Value: DDUPDATEMETADATA_HIGHLIGHT),
       (Ident: 'DDUPDATEMETADATA_NOHIGHLIGHT'; Value: DDUPDATEMETADATA_NOHIGHLIGHT),
       (Ident: 'DD_WARNING'; Value: DD_WARNING),
       (Ident: 'DDWARNING_HIGHLIGHT'; Value: DDWARNING_HIGHLIGHT),
       (Ident: 'DDWARNING_NOHIGHLIGHT'; Value: DDWARNING_NOHIGHLIGHT),
       (Ident: 'EP_BACKGROUND'; Value: EP_BACKGROUND),
       (Ident: 'EBS_ASSIST'; Value: EBS_ASSIST),
       (Ident: 'EBS_DISABLED'; Value: EBS_DISABLED),
       (Ident: 'EBS_FOCUSED'; Value: EBS_FOCUSED),
       (Ident: 'EBS_HOT'; Value: EBS_HOT),
       (Ident: 'EBS_NORMAL'; Value: EBS_NORMAL),
       (Ident: 'EBS_READONLY'; Value: EBS_READONLY),
       (Ident: 'EP_BACKGROUNDWITHBORDER'; Value: EP_BACKGROUNDWITHBORDER),
       (Ident: 'EBWBS_DISABLED'; Value: EBWBS_DISABLED),
       (Ident: 'EBWBS_FOCUSED'; Value: EBWBS_FOCUSED),
       (Ident: 'EBWBS_HOT'; Value: EBWBS_HOT),
       (Ident: 'EBWBS_NORMAL'; Value: EBWBS_NORMAL),
       (Ident: 'EP_CARET'; Value: EP_CARET),
       (Ident: 'EP_EDITBORDER_HSCROLL'; Value: EP_EDITBORDER_HSCROLL),
       (Ident: 'EPSH_DISABLED'; Value: EPSH_DISABLED),
       (Ident: 'EPSH_FOCUSED'; Value: EPSH_FOCUSED),
       (Ident: 'EPSH_HOT'; Value: EPSH_HOT),
       (Ident: 'EPSH_NORMAL'; Value: EPSH_NORMAL),
       (Ident: 'EP_EDITBORDER_HVSCROLL'; Value: EP_EDITBORDER_HVSCROLL),
       (Ident: 'EPSHV_DISABLED'; Value: EPSHV_DISABLED),
       (Ident: 'EPSHV_FOCUSED'; Value: EPSHV_FOCUSED),
       (Ident: 'EPSHV_HOT'; Value: EPSHV_HOT),
       (Ident: 'EPSHV_NORMAL'; Value: EPSHV_NORMAL),
       (Ident: 'EP_EDITBORDER_NOSCROLL'; Value: EP_EDITBORDER_NOSCROLL),
       (Ident: 'EPSN_DISABLED'; Value: EPSN_DISABLED),
       (Ident: 'EPSN_FOCUSED'; Value: EPSN_FOCUSED),
       (Ident: 'EPSN_HOT'; Value: EPSN_HOT),
       (Ident: 'EPSN_NORMAL'; Value: EPSN_NORMAL),
       (Ident: 'EP_EDITBORDER_VSCROLL'; Value: EP_EDITBORDER_VSCROLL),
       (Ident: 'EPSV_DISABLED'; Value: EPSV_DISABLED),
       (Ident: 'EPSV_FOCUSED'; Value: EPSV_FOCUSED),
       (Ident: 'EPSV_HOT'; Value: EPSV_HOT),
       (Ident: 'EPSV_NORMAL'; Value: EPSV_NORMAL),
       (Ident: 'EP_EDITTEXT'; Value: EP_EDITTEXT),
       (Ident: 'ETS_ASSIST'; Value: ETS_ASSIST),
       (Ident: 'ETS_CUEBANNER'; Value: ETS_CUEBANNER),
       (Ident: 'ETS_DISABLED'; Value: ETS_DISABLED),
       (Ident: 'ETS_FOCUSED'; Value: ETS_FOCUSED),
       (Ident: 'ETS_HOT'; Value: ETS_HOT),
       (Ident: 'ETS_NORMAL'; Value: ETS_NORMAL),
       (Ident: 'ETS_READONLY'; Value: ETS_READONLY),
       (Ident: 'ETS_SELECTED'; Value: ETS_SELECTED),
       (Ident: 'EP_PASSWORD'; Value: EP_PASSWORD),
       (Ident: 'EBP_HEADERBACKGROUND'; Value: EBP_HEADERBACKGROUND),
       (Ident: 'EBP_HEADERCLOSE'; Value: EBP_HEADERCLOSE),
       (Ident: 'EBHC_HOT'; Value: EBHC_HOT),
       (Ident: 'EBHC_NORMAL'; Value: EBHC_NORMAL),
       (Ident: 'EBHC_PRESSED'; Value: EBHC_PRESSED),
       (Ident: 'EBP_HEADERPIN'; Value: EBP_HEADERPIN),
       (Ident: 'EBHP_HOT'; Value: EBHP_HOT),
       (Ident: 'EBHP_NORMAL'; Value: EBHP_NORMAL),
       (Ident: 'EBHP_PRESSED'; Value: EBHP_PRESSED),
       (Ident: 'EBHP_SELECTEDHOT'; Value: EBHP_SELECTEDHOT),
       (Ident: 'EBHP_SELECTEDNORMAL'; Value: EBHP_SELECTEDNORMAL),
       (Ident: 'EBHP_SELECTEDPRESSED'; Value: EBHP_SELECTEDPRESSED),
       (Ident: 'EBP_IEBARMENU'; Value: EBP_IEBARMENU),
       (Ident: 'EBM_HOT'; Value: EBM_HOT),
       (Ident: 'EBM_NORMAL'; Value: EBM_NORMAL),
       (Ident: 'EBM_PRESSED'; Value: EBM_PRESSED),
       (Ident: 'EBP_NORMALGROUPBACKGROUND'; Value: EBP_NORMALGROUPBACKGROUND),
       (Ident: 'EBP_NORMALGROUPCOLLAPSE'; Value: EBP_NORMALGROUPCOLLAPSE),
       (Ident: 'EBNGC_HOT'; Value: EBNGC_HOT),
       (Ident: 'EBNGC_NORMAL'; Value: EBNGC_NORMAL),
       (Ident: 'EBNGC_PRESSED'; Value: EBNGC_PRESSED),
       (Ident: 'EBP_NORMALGROUPEXPAND'; Value: EBP_NORMALGROUPEXPAND),
       (Ident: 'EBNGE_HOT'; Value: EBNGE_HOT),
       (Ident: 'EBNGE_NORMAL'; Value: EBNGE_NORMAL),
       (Ident: 'EBNGE_PRESSED'; Value: EBNGE_PRESSED),
       (Ident: 'EBP_NORMALGROUPHEAD'; Value: EBP_NORMALGROUPHEAD),
       (Ident: 'EBP_SPECIALGROUPBACKGROUND'; Value: EBP_SPECIALGROUPBACKGROUND),
       (Ident: 'EBP_SPECIALGROUPCOLLAPSE'; Value: EBP_SPECIALGROUPCOLLAPSE),
       (Ident: 'EBSGC_HOT'; Value: EBSGC_HOT),
       (Ident: 'EBSGC_NORMAL'; Value: EBSGC_NORMAL),
       (Ident: 'EBSGC_PRESSED'; Value: EBSGC_PRESSED),
       (Ident: 'EBP_SPECIALGROUPEXPAND'; Value: EBP_SPECIALGROUPEXPAND),
       (Ident: 'EBSGE_HOT'; Value: EBSGE_HOT),
       (Ident: 'EBSGE_NORMAL'; Value: EBSGE_NORMAL),
       (Ident: 'EBSGE_PRESSED'; Value: EBSGE_PRESSED),
       (Ident: 'EBP_SPECIALGROUPHEAD'; Value: EBP_SPECIALGROUPHEAD),
       (Ident: 'FLYOUT_BODY'; Value: FLYOUT_BODY),
       (Ident: 'FBS_EMPHASIZED'; Value: FBS_EMPHASIZED),
       (Ident: 'FBS_NORMAL'; Value: FBS_NORMAL),
       (Ident: 'FLYOUT_DIVIDER'; Value: FLYOUT_DIVIDER),
       (Ident: 'FLYOUT_HEADER'; Value: FLYOUT_HEADER),
       (Ident: 'FLYOUT_LABEL'; Value: FLYOUT_LABEL),
       (Ident: 'FLS_DISABLED'; Value: FLS_DISABLED),
       (Ident: 'FLS_EMPHASIZED'; Value: FLS_EMPHASIZED),
       (Ident: 'FLS_NORMAL'; Value: FLS_NORMAL),
       (Ident: 'FLS_SELECTED'; Value: FLS_SELECTED),
       (Ident: 'FLYOUT_LINK'; Value: FLYOUT_LINK),
       (Ident: 'FLYOUTLINK_HOVER'; Value: FLYOUTLINK_HOVER),
       (Ident: 'FLYOUTLINK_NORMAL'; Value: FLYOUTLINK_NORMAL),
       (Ident: 'FLYOUT_LINKAREA'; Value: FLYOUT_LINKAREA),
       (Ident: 'FLYOUT_LINKHEADER'; Value: FLYOUT_LINKHEADER),
       (Ident: 'FLH_HOVER'; Value: FLH_HOVER),
       (Ident: 'FLH_NORMAL'; Value: FLH_NORMAL),
       (Ident: 'FLYOUT_WINDOW'; Value: FLYOUT_WINDOW),
       (Ident: 'GP_BORDER'; Value: GP_BORDER),
       (Ident: 'BSS_FLAT'; Value: BSS_FLAT),
       (Ident: 'BSS_RAISED'; Value: BSS_RAISED),
       (Ident: 'BSS_SUNKEN'; Value: BSS_SUNKEN),
       (Ident: 'GP_LINEHORZ'; Value: GP_LINEHORZ),
       (Ident: 'LHS_FLAT'; Value: LHS_FLAT),
       (Ident: 'LHS_RAISED'; Value: LHS_RAISED),
       (Ident: 'LHS_SUNKEN'; Value: LHS_SUNKEN),
       (Ident: 'GP_LINEVERT'; Value: GP_LINEVERT),
       (Ident: 'LVS_FLAT'; Value: LVS_FLAT),
       (Ident: 'LVS_RAISED'; Value: LVS_RAISED),
       (Ident: 'LVS_SUNKEN'; Value: LVS_SUNKEN),
       (Ident: 'HP_HEADERDROPDOWN'; Value: HP_HEADERDROPDOWN),
       (Ident: 'HDDS_HOT'; Value: HDDS_HOT),
       (Ident: 'HDDS_NORMAL'; Value: HDDS_NORMAL),
       (Ident: 'HDDS_SOFTHOT'; Value: HDDS_SOFTHOT),
       (Ident: 'HP_HEADERDROPDOWNFILTER'; Value: HP_HEADERDROPDOWNFILTER),
       (Ident: 'HDDFS_HOT'; Value: HDDFS_HOT),
       (Ident: 'HDDFS_NORMAL'; Value: HDDFS_NORMAL),
       (Ident: 'HDDFS_SOFTHOT'; Value: HDDFS_SOFTHOT),
       (Ident: 'HP_HEADERITEM'; Value: HP_HEADERITEM),
       (Ident: 'HIS_HOT'; Value: HIS_HOT),
       (Ident: 'HIS_ICONHOT'; Value: HIS_ICONHOT),
       (Ident: 'HIS_ICONNORMAL'; Value: HIS_ICONNORMAL),
       (Ident: 'HIS_ICONPRESSED'; Value: HIS_ICONPRESSED),
       (Ident: 'HIS_ICONSORTEDHOT'; Value: HIS_ICONSORTEDHOT),
       (Ident: 'HIS_ICONSORTEDNORMAL'; Value: HIS_ICONSORTEDNORMAL),
       (Ident: 'HIS_ICONSORTEDPRESSED'; Value: HIS_ICONSORTEDPRESSED),
       (Ident: 'HIS_NORMAL'; Value: HIS_NORMAL),
       (Ident: 'HIS_PRESSED'; Value: HIS_PRESSED),
       (Ident: 'HIS_SORTEDNORMAL'; Value: HIS_SORTEDNORMAL),
       (Ident: 'HIS_SORTEDHOT'; Value: HIS_SORTEDHOT),
       (Ident: 'HIS_SORTEDPRESSED'; Value: HIS_SORTEDPRESSED),
       (Ident: 'HP_HEADERITEMLEFT'; Value: HP_HEADERITEMLEFT),
       (Ident: 'HILS_HOT'; Value: HILS_HOT),
       (Ident: 'HILS_NORMAL'; Value: HILS_NORMAL),
       (Ident: 'HILS_PRESSED'; Value: HILS_PRESSED),
       (Ident: 'HP_HEADERITEMRIGHT'; Value: HP_HEADERITEMRIGHT),
       (Ident: 'HIRS_HOT'; Value: HIRS_HOT),
       (Ident: 'HIRS_NORMAL'; Value: HIRS_NORMAL),
       (Ident: 'HIRS_PRESSED'; Value: HIRS_PRESSED),
       (Ident: 'HP_HEADEROVERFLOW'; Value: HP_HEADEROVERFLOW),
       (Ident: 'HOFS_HOT'; Value: HOFS_HOT),
       (Ident: 'HOFS_NORMAL'; Value: HOFS_NORMAL),
       (Ident: 'HP_HEADERSORTARROW'; Value: HP_HEADERSORTARROW),
       (Ident: 'HSAS_SORTEDDOWN'; Value: HSAS_SORTEDDOWN),
       (Ident: 'HSAS_SORTEDUP'; Value: HSAS_SORTEDUP),
       (Ident: 'LBCP_BORDER_HSCROLL'; Value: LBCP_BORDER_HSCROLL),
       (Ident: 'LBPSH_DISABLED'; Value: LBPSH_DISABLED),
       (Ident: 'LBPSH_FOCUSED'; Value: LBPSH_FOCUSED),
       (Ident: 'LBPSH_HOT'; Value: LBPSH_HOT),
       (Ident: 'LBPSH_NORMAL'; Value: LBPSH_NORMAL),
       (Ident: 'LBCP_BORDER_HVSCROLL'; Value: LBCP_BORDER_HVSCROLL),
       (Ident: 'LBPSHV_DISABLED'; Value: LBPSHV_DISABLED),
       (Ident: 'LBPSHV_FOCUSED'; Value: LBPSHV_FOCUSED),
       (Ident: 'LBPSHV_HOT'; Value: LBPSHV_HOT),
       (Ident: 'LBPSHV_NORMAL'; Value: LBPSHV_NORMAL),
       (Ident: 'LBCP_BORDER_NOSCROLL'; Value: LBCP_BORDER_NOSCROLL),
       (Ident: 'LBPSN_DISABLED'; Value: LBPSN_DISABLED),
       (Ident: 'LBPSN_FOCUSED'; Value: LBPSN_FOCUSED),
       (Ident: 'LBPSN_HOT'; Value: LBPSN_HOT),
       (Ident: 'LBPSN_NORMAL'; Value: LBPSN_NORMAL),
       (Ident: 'LBCP_BORDER_VSCROLL'; Value: LBCP_BORDER_VSCROLL),
       (Ident: 'LBPSV_DISABLED'; Value: LBPSV_DISABLED),
       (Ident: 'LBPSV_FOCUSED'; Value: LBPSV_FOCUSED),
       (Ident: 'LBPSV_HOT'; Value: LBPSV_HOT),
       (Ident: 'LBPSV_NORMAL'; Value: LBPSV_NORMAL),
       (Ident: 'LBCP_ITEM'; Value: LBCP_ITEM),
       (Ident: 'LBPSI_HOT'; Value: LBPSI_HOT),
       (Ident: 'LBPSI_HOTSELECTED'; Value: LBPSI_HOTSELECTED),
       (Ident: 'LBPSI_SELECTED'; Value: LBPSI_SELECTED),
       (Ident: 'LBPSI_SELECTEDNOTFOCUS'; Value: LBPSI_SELECTEDNOTFOCUS),
       (Ident: 'LVP_COLLAPSEBUTTON'; Value: LVP_COLLAPSEBUTTON),
       (Ident: 'LVCB_HOVER'; Value: LVCB_HOVER),
       (Ident: 'LVCB_NORMAL'; Value: LVCB_NORMAL),
       (Ident: 'LVCB_PUSHED'; Value: LVCB_PUSHED),
       (Ident: 'LVP_COLUMNDETAIL'; Value: LVP_COLUMNDETAIL),
       (Ident: 'LVP_EMPTYTEXT'; Value: LVP_EMPTYTEXT),
       (Ident: 'LVP_EXPANDBUTTON'; Value: LVP_EXPANDBUTTON),
       (Ident: 'LVEB_HOVER'; Value: LVEB_HOVER),
       (Ident: 'LVEB_NORMAL'; Value: LVEB_NORMAL),
       (Ident: 'LVEB_PUSHED'; Value: LVEB_PUSHED),
       (Ident: 'LVP_GROUPHEADER'; Value: LVP_GROUPHEADER),
       (Ident: 'LVGH_CLOSE'; Value: LVGH_CLOSE),
       (Ident: 'LVGH_CLOSEHOT'; Value: LVGH_CLOSEHOT),
       (Ident: 'LVGH_CLOSESELECTED'; Value: LVGH_CLOSESELECTED),
       (Ident: 'LVGH_CLOSESELECTEDHOT'; Value: LVGH_CLOSESELECTEDHOT),
       (Ident: 'LVGH_CLOSESELECTEDNOTFOCUSED'; Value: LVGH_CLOSESELECTEDNOTFOCUSED),
       (Ident: 'LVGH_CLOSESELECTEDNOTFOCUSEDHOT'; Value: LVGH_CLOSESELECTEDNOTFOCUSEDHOT),
       (Ident: 'LVGH_CLOSEMIXEDSELECTION'; Value: LVGH_CLOSEMIXEDSELECTION),
       (Ident: 'LVGH_CLOSEMIXEDSELECTIONHOT'; Value: LVGH_CLOSEMIXEDSELECTIONHOT),
       (Ident: 'LVGH_OPEN'; Value: LVGH_OPEN),
       (Ident: 'LVGH_OPENHOT'; Value: LVGH_OPENHOT),
       (Ident: 'LVGH_OPENSELECTED'; Value: LVGH_OPENSELECTED),
       (Ident: 'LVGH_OPENSELECTEDHOT'; Value: LVGH_OPENSELECTEDHOT),
       (Ident: 'LVGH_OPENSELECTEDNOTFOCUSED'; Value: LVGH_OPENSELECTEDNOTFOCUSED),
       (Ident: 'LVGH_OPENSELECTEDNOTFOCUSEDHOT'; Value: LVGH_OPENSELECTEDNOTFOCUSEDHOT),
       (Ident: 'LVGH_OPENMIXEDSELECTION'; Value: LVGH_OPENMIXEDSELECTION),
       (Ident: 'LVGH_OPENMIXEDSELECTIONHOT'; Value: LVGH_OPENMIXEDSELECTIONHOT),
       (Ident: 'LVP_GROUPHEADERLINE'; Value: LVP_GROUPHEADERLINE),
       (Ident: 'LVGHL_CLOSE'; Value: LVGHL_CLOSE),
       (Ident: 'LVGHL_CLOSEHOT'; Value: LVGHL_CLOSEHOT),
       (Ident: 'LVGHL_CLOSESELECTED'; Value: LVGHL_CLOSESELECTED),
       (Ident: 'LVGHL_CLOSESELECTEDHOT'; Value: LVGHL_CLOSESELECTEDHOT),
       (Ident: 'LVGHL_CLOSESELECTEDNOTFOCUSED'; Value: LVGHL_CLOSESELECTEDNOTFOCUSED),
       (Ident: 'LVGHL_CLOSESELECTEDNOTFOCUSEDHOT'; Value: LVGHL_CLOSESELECTEDNOTFOCUSEDHOT),
       (Ident: 'LVGHL_CLOSEMIXEDSELECTION'; Value: LVGHL_CLOSEMIXEDSELECTION),
       (Ident: 'LVGHL_CLOSEMIXEDSELECTIONHOT'; Value: LVGHL_CLOSEMIXEDSELECTIONHOT),
       (Ident: 'LVGHL_OPEN'; Value: LVGHL_OPEN),
       (Ident: 'LVGHL_OPENHOT'; Value: LVGHL_OPENHOT),
       (Ident: 'LVGHL_OPENSELECTED'; Value: LVGHL_OPENSELECTED),
       (Ident: 'LVGHL_OPENSELECTEDHOT'; Value: LVGHL_OPENSELECTEDHOT),
       (Ident: 'LVGHL_OPENSELECTEDNOTFOCUSED'; Value: LVGHL_OPENSELECTEDNOTFOCUSED),
       (Ident: 'LVGHL_OPENSELECTEDNOTFOCUSEDHOT'; Value: LVGHL_OPENSELECTEDNOTFOCUSEDHOT),
       (Ident: 'LVGHL_OPENMIXEDSELECTION'; Value: LVGHL_OPENMIXEDSELECTION),
       (Ident: 'LVGHL_OPENMIXEDSELECTIONHOT'; Value: LVGHL_OPENMIXEDSELECTIONHOT),
       (Ident: 'LVP_LISTGROUP'; Value: LVP_LISTGROUP),
       (Ident: 'LVP_LISTDETAIL'; Value: LVP_LISTDETAIL),
       (Ident: 'LVP_LISTITEM'; Value: LVP_LISTITEM),
       (Ident: 'LISS_DISABLED'; Value: LISS_DISABLED),
       (Ident: 'LISS_HOT'; Value: LISS_HOT),
       (Ident: 'LISS_HOTSELECTED'; Value: LISS_HOTSELECTED),
       (Ident: 'LISS_NORMAL'; Value: LISS_NORMAL),
       (Ident: 'LISS_SELECTED'; Value: LISS_SELECTED),
       (Ident: 'LISS_SELECTEDNOTFOCUS'; Value: LISS_SELECTEDNOTFOCUS),
       (Ident: 'LVP_LISTSORTEDDETAIL'; Value: LVP_LISTSORTEDDETAIL),
       (Ident: 'MENU_BARBACKGROUND'; Value: MENU_BARBACKGROUND),
       (Ident: 'MB_ACTIVE'; Value: MB_ACTIVE),
       (Ident: 'MB_INACTIVE'; Value: MB_INACTIVE),
       (Ident: 'MENU_BARITEM'; Value: MENU_BARITEM),
       (Ident: 'MBI_DISABLED'; Value: MBI_DISABLED),
       (Ident: 'MBI_DISABLEDHOT'; Value: MBI_DISABLEDHOT),
       (Ident: 'MBI_DISABLEDPUSHED'; Value: MBI_DISABLEDPUSHED),
       (Ident: 'MBI_HOT'; Value: MBI_HOT),
       (Ident: 'MBI_NORMAL'; Value: MBI_NORMAL),
       (Ident: 'MBI_PUSHED'; Value: MBI_PUSHED),
       (Ident: 'MENU_CHEVRON_TMSCHEMA'; Value: MENU_CHEVRON_TMSCHEMA),
       (Ident: 'MENU_MENUBARDROPDOWN_TMSCHEMA'; Value: MENU_MENUBARDROPDOWN_TMSCHEMA),
       (Ident: 'MENU_MENUBARITEM_TMSCHEMA'; Value: MENU_MENUBARITEM_TMSCHEMA),
       (Ident: 'MENU_MENUDROPDOWN_TMSCHEMA'; Value: MENU_MENUDROPDOWN_TMSCHEMA),
       (Ident: 'MENU_MENUITEM_TMSCHEMA'; Value: MENU_MENUITEM_TMSCHEMA),
       (Ident: 'MENU_POPUPBACKGROUND'; Value: MENU_POPUPBACKGROUND),
       (Ident: 'MENU_POPUPBORDERS'; Value: MENU_POPUPBORDERS),
       (Ident: 'MENU_POPUPCHECK'; Value: MENU_POPUPCHECK),
       (Ident: 'MC_BULLETDISABLED'; Value: MC_BULLETDISABLED),
       (Ident: 'MC_BULLETNORMAL'; Value: MC_BULLETNORMAL),
       (Ident: 'MC_CHECKMARKDISABLED'; Value: MC_CHECKMARKDISABLED),
       (Ident: 'MC_CHECKMARKNORMAL'; Value: MC_CHECKMARKNORMAL),
       (Ident: 'MENU_POPUPCHECKBACKGROUND'; Value: MENU_POPUPCHECKBACKGROUND),
       (Ident: 'MCB_BITMAP'; Value: MCB_BITMAP),
       (Ident: 'MCB_DISABLED'; Value: MCB_DISABLED),
       (Ident: 'MCB_NORMAL'; Value: MCB_NORMAL),
       (Ident: 'MENU_POPUPGUTTER'; Value: MENU_POPUPGUTTER),
       (Ident: 'MENU_POPUPITEM'; Value: MENU_POPUPITEM),
       (Ident: 'MPI_DISABLED'; Value: MPI_DISABLED),
       (Ident: 'MPI_DISABLEDHOT'; Value: MPI_DISABLEDHOT),
       (Ident: 'MPI_HOT'; Value: MPI_HOT),
       (Ident: 'MPI_NORMAL'; Value: MPI_NORMAL),
       (Ident: 'MENU_POPUPSEPARATOR'; Value: MENU_POPUPSEPARATOR),
       (Ident: 'MENU_POPUPSUBMENU'; Value: MENU_POPUPSUBMENU),
       (Ident: 'MSM_DISABLED'; Value: MSM_DISABLED),
       (Ident: 'MSM_NORMAL'; Value: MSM_NORMAL),
       (Ident: 'MENU_SEPARATOR_TMSCHEMA'; Value: MENU_SEPARATOR_TMSCHEMA),
       (Ident: 'MENU_SYSTEMCLOSE'; Value: MENU_SYSTEMCLOSE),
       (Ident: 'MSYSC_DISABLED'; Value: MSYSC_DISABLED),
       (Ident: 'MSYSC_NORMAL'; Value: MSYSC_NORMAL),
       (Ident: 'MENU_SYSTEMMAXIMIZE'; Value: MENU_SYSTEMMAXIMIZE),
       (Ident: 'MSYSMX_DISABLED'; Value: MSYSMX_DISABLED),
       (Ident: 'MSYSMX_NORMAL'; Value: MSYSMX_NORMAL),
       (Ident: 'MENU_SYSTEMMINIMIZE'; Value: MENU_SYSTEMMINIMIZE),
       (Ident: 'MSYSMN_DISABLED'; Value: MSYSMN_DISABLED),
       (Ident: 'MSYSMN_NORMAL'; Value: MSYSMN_NORMAL),
       (Ident: 'MENU_SYSTEMRESTORE'; Value: MENU_SYSTEMRESTORE),
       (Ident: 'MSYSR_DISABLED'; Value: MSYSR_DISABLED),
       (Ident: 'MSYSR_NORMAL'; Value: MSYSR_NORMAL),
       (Ident: 'MDP_NEWAPPBUTTON'; Value: MDP_NEWAPPBUTTON),
       (Ident: 'MDS_CHECKED'; Value: MDS_CHECKED),
       (Ident: 'MDS_DISABLED'; Value: MDS_DISABLED),
       (Ident: 'MDS_HOT'; Value: MDS_HOT),
       (Ident: 'MDS_HOTCHECKED'; Value: MDS_HOTCHECKED),
       (Ident: 'MDS_NORMAL'; Value: MDS_NORMAL),
       (Ident: 'MDS_PRESSED'; Value: MDS_PRESSED),
       (Ident: 'MDP_SEPERATOR'; Value: MDP_SEPERATOR),
       (Ident: 'NAV_BACKBUTTON'; Value: NAV_BACKBUTTON),
       (Ident: 'NAV_BB_DISABLED'; Value: NAV_BB_DISABLED),
       (Ident: 'NAV_BB_HOT'; Value: NAV_BB_HOT),
       (Ident: 'NAV_BB_NORMAL'; Value: NAV_BB_NORMAL),
       (Ident: 'NAV_BB_PRESSED'; Value: NAV_BB_PRESSED),
       (Ident: 'NAV_FORWARDBUTTON'; Value: NAV_FORWARDBUTTON),
       (Ident: 'NAV_FB_DISABLED'; Value: NAV_FB_DISABLED),
       (Ident: 'NAV_FB_HOT'; Value: NAV_FB_HOT),
       (Ident: 'NAV_FB_NORMAL'; Value: NAV_FB_NORMAL),
       (Ident: 'NAV_FB_PRESSED'; Value: NAV_FB_PRESSED),
       (Ident: 'NAV_MENUBUTTON'; Value: NAV_MENUBUTTON),
       (Ident: 'NAV_MB_DISABLED'; Value: NAV_MB_DISABLED),
       (Ident: 'NAV_MB_HOT'; Value: NAV_MB_HOT),
       (Ident: 'NAV_MB_NORMAL'; Value: NAV_MB_NORMAL),
       (Ident: 'NAV_MB_PRESSED'; Value: NAV_MB_PRESSED),
       (Ident: 'PGRP_DOWN'; Value: PGRP_DOWN),
       (Ident: 'DNS_DISABLED'; Value: DNS_DISABLED),
       (Ident: 'DNS_HOT'; Value: DNS_HOT),
       (Ident: 'DNS_NORMAL'; Value: DNS_NORMAL),
       (Ident: 'DNS_PRESSED'; Value: DNS_PRESSED),
       (Ident: 'PGRP_DOWNHORZ'; Value: PGRP_DOWNHORZ),
       (Ident: 'DNHZS_DISABLED'; Value: DNHZS_DISABLED),
       (Ident: 'DNHZS_HOT'; Value: DNHZS_HOT),
       (Ident: 'DNHZS_NORMAL'; Value: DNHZS_NORMAL),
       (Ident: 'DNHZS_PRESSED'; Value: DNHZS_PRESSED),
       (Ident: 'PGRP_UP'; Value: PGRP_UP),
       (Ident: 'UPS_DISABLED'; Value: UPS_DISABLED),
       (Ident: 'UPS_HOT'; Value: UPS_HOT),
       (Ident: 'UPS_NORMAL'; Value: UPS_NORMAL),
       (Ident: 'UPS_PRESSED'; Value: UPS_PRESSED),
       (Ident: 'PGRP_UPHORZ'; Value: PGRP_UPHORZ),
       (Ident: 'UPHZS_DISABLED'; Value: UPHZS_DISABLED),
       (Ident: 'UPHZS_HOT'; Value: UPHZS_HOT),
       (Ident: 'UPHZS_NORMAL'; Value: UPHZS_NORMAL),
       (Ident: 'UPHZS_PRESSED'; Value: UPHZS_PRESSED),
       (Ident: 'PP_BAR'; Value: PP_BAR),
       (Ident: 'PP_BARVERT'; Value: PP_BARVERT),
       (Ident: 'PP_CHUNK'; Value: PP_CHUNK),
       (Ident: 'PP_CHUNKVERT'; Value: PP_CHUNKVERT),
       (Ident: 'PP_FILL'; Value: PP_FILL),
       (Ident: 'PBFS_ERROR'; Value: PBFS_ERROR),
       (Ident: 'PBFS_NORMAL'; Value: PBFS_NORMAL),
       (Ident: 'PBFS_PARTIAL'; Value: PBFS_PARTIAL),
       (Ident: 'PBFS_PAUSED'; Value: PBFS_PAUSED),
       (Ident: 'PP_FILLVERT'; Value: PP_FILLVERT),
       (Ident: 'PBFVS_ERROR'; Value: PBFVS_ERROR),
       (Ident: 'PBFVS_NORMAL'; Value: PBFVS_NORMAL),
       (Ident: 'PBFVS_PARTIAL'; Value: PBFVS_PARTIAL),
       (Ident: 'PBFVS_PAUSED'; Value: PBFVS_PAUSED),
       (Ident: 'PP_MOVEOVERLAY'; Value: PP_MOVEOVERLAY),
       (Ident: 'PP_MOVEOVERLAYVERT'; Value: PP_MOVEOVERLAYVERT),
       (Ident: 'PP_PULSEOVERLAY'; Value: PP_PULSEOVERLAY),
       (Ident: 'PP_PULSEOVERLAYVERT'; Value: PP_PULSEOVERLAYVERT),
       (Ident: 'PP_TRANSPARENTBAR'; Value: PP_TRANSPARENTBAR),
       (Ident: 'PBBS_NORMAL'; Value: PBBS_NORMAL),
       (Ident: 'PBBS_PARTIAL'; Value: PBBS_PARTIAL),
       (Ident: 'PP_TRANSPARENTBARVERT'; Value: PP_TRANSPARENTBARVERT),
       (Ident: 'PBBVS_NORMAL'; Value: PBBVS_NORMAL),
       (Ident: 'PBBVS_PARTIAL'; Value: PBBVS_PARTIAL),
       (Ident: 'RP_BACKGROUND'; Value: RP_BACKGROUND),
       (Ident: 'RP_BAND'; Value: RP_BAND),
       (Ident: 'RP_CHEVRON'; Value: RP_CHEVRON),
       (Ident: 'CHEVS_HOT'; Value: CHEVS_HOT),
       (Ident: 'CHEVS_NORMAL'; Value: CHEVS_NORMAL),
       (Ident: 'CHEVS_PRESSED'; Value: CHEVS_PRESSED),
       (Ident: 'RP_CHEVRONVERT'; Value: RP_CHEVRONVERT),
       (Ident: 'CHEVSV_HOT'; Value: CHEVSV_HOT),
       (Ident: 'CHEVSV_NORMAL'; Value: CHEVSV_NORMAL),
       (Ident: 'CHEVSV_PRESSED'; Value: CHEVSV_PRESSED),
       (Ident: 'RP_GRIPPER'; Value: RP_GRIPPER),
       (Ident: 'RP_GRIPPERVERT'; Value: RP_GRIPPERVERT),
       (Ident: 'RP_SPLITTER'; Value: RP_SPLITTER),
       (Ident: 'SPLITS_HOT'; Value: SPLITS_HOT),
       (Ident: 'SPLITS_NORMAL'; Value: SPLITS_NORMAL),
       (Ident: 'SPLITS_PRESSED'; Value: SPLITS_PRESSED),
       (Ident: 'RP_SPLITTERVERT'; Value: RP_SPLITTERVERT),
       (Ident: 'SPLITSV_HOT'; Value: SPLITSV_HOT),
       (Ident: 'SPLITSV_NORMAL'; Value: SPLITSV_NORMAL),
       (Ident: 'SPLITSV_PRESSED'; Value: SPLITSV_PRESSED),
       (Ident: 'SBP_ARROWBTN'; Value: SBP_ARROWBTN),
       (Ident: 'ABS_DOWNDISABLED'; Value: ABS_DOWNDISABLED),
       (Ident: 'ABS_DOWNHOT'; Value: ABS_DOWNHOT),
       (Ident: 'ABS_DOWNNORMAL'; Value: ABS_DOWNNORMAL),
       (Ident: 'ABS_DOWNPRESSED'; Value: ABS_DOWNPRESSED),
       (Ident: 'ABS_DOWNHOVER'; Value: ABS_DOWNHOVER),
       (Ident: 'ABS_LEFTDISABLED'; Value: ABS_LEFTDISABLED),
       (Ident: 'ABS_LEFTHOT'; Value: ABS_LEFTHOT),
       (Ident: 'ABS_LEFTHOVER'; Value: ABS_LEFTHOVER),
       (Ident: 'ABS_LEFTNORMAL'; Value: ABS_LEFTNORMAL),
       (Ident: 'ABS_LEFTPRESSED'; Value: ABS_LEFTPRESSED),
       (Ident: 'ABS_RIGHTDISABLED'; Value: ABS_RIGHTDISABLED),
       (Ident: 'ABS_RIGHTHOT'; Value: ABS_RIGHTHOT),
       (Ident: 'ABS_RIGHTHOVER'; Value: ABS_RIGHTHOVER),
       (Ident: 'ABS_RIGHTNORMAL'; Value: ABS_RIGHTNORMAL),
       (Ident: 'ABS_RIGHTPRESSED'; Value: ABS_RIGHTPRESSED),
       (Ident: 'ABS_UPDISABLED'; Value: ABS_UPDISABLED),
       (Ident: 'ABS_UPHOT'; Value: ABS_UPHOT),
       (Ident: 'ABS_UPHOVER'; Value: ABS_UPHOVER),
       (Ident: 'ABS_UPNORMAL'; Value: ABS_UPNORMAL),
       (Ident: 'ABS_UPPRESSED'; Value: ABS_UPPRESSED),
       (Ident: 'SBP_GRIPPERHORZ'; Value: SBP_GRIPPERHORZ),
       (Ident: 'SCRBS_DISABLED'; Value: SCRBS_DISABLED),
       (Ident: 'SCRBS_HOT'; Value: SCRBS_HOT),
       (Ident: 'SCRBS_HOVER'; Value: SCRBS_HOVER),
       (Ident: 'SCRBS_NORMAL'; Value: SCRBS_NORMAL),
       (Ident: 'SCRBS_PRESSED'; Value: SCRBS_PRESSED),
       (Ident: 'SBP_GRIPPERVERT'; Value: SBP_GRIPPERVERT),
       (Ident: 'SCRBS_DISABLED'; Value: SCRBS_DISABLED),
       (Ident: 'SCRBS_HOT'; Value: SCRBS_HOT),
       (Ident: 'SCRBS_HOVER'; Value: SCRBS_HOVER),
       (Ident: 'SCRBS_NORMAL'; Value: SCRBS_NORMAL),
       (Ident: 'SCRBS_PRESSED'; Value: SCRBS_PRESSED),
       (Ident: 'SBP_LOWERTRACKHORZ'; Value: SBP_LOWERTRACKHORZ),
       (Ident: 'SCRBS_DISABLED'; Value: SCRBS_DISABLED),
       (Ident: 'SCRBS_HOT'; Value: SCRBS_HOT),
       (Ident: 'SCRBS_HOVER'; Value: SCRBS_HOVER),
       (Ident: 'SCRBS_NORMAL'; Value: SCRBS_NORMAL),
       (Ident: 'SCRBS_PRESSED'; Value: SCRBS_PRESSED),
       (Ident: 'SBP_LOWERTRACKVERT'; Value: SBP_LOWERTRACKVERT),
       (Ident: 'SCRBS_DISABLED'; Value: SCRBS_DISABLED),
       (Ident: 'SCRBS_HOT'; Value: SCRBS_HOT),
       (Ident: 'SCRBS_HOVER'; Value: SCRBS_HOVER),
       (Ident: 'SCRBS_NORMAL'; Value: SCRBS_NORMAL),
       (Ident: 'SCRBS_PRESSED'; Value: SCRBS_PRESSED),
       (Ident: 'SBP_SIZEBOX'; Value: SBP_SIZEBOX),
       (Ident: 'SZB_HALFBOTTOMRIGHTALIGN'; Value: SZB_HALFBOTTOMRIGHTALIGN),
       (Ident: 'SZB_HALFBOTTOMLEFTALIGN'; Value: SZB_HALFBOTTOMLEFTALIGN),
       (Ident: 'SZB_HALFTOPRIGHTALIGN'; Value: SZB_HALFTOPRIGHTALIGN),
       (Ident: 'SZB_HALFTOPLEFTALIGN'; Value: SZB_HALFTOPLEFTALIGN),
       (Ident: 'SZB_LEFTALIGN'; Value: SZB_LEFTALIGN),
       (Ident: 'SZB_RIGHTALIGN'; Value: SZB_RIGHTALIGN),
       (Ident: 'SZB_TOPRIGHTALIGN'; Value: SZB_TOPRIGHTALIGN),
       (Ident: 'SZB_TOPLEFTALIGN'; Value: SZB_TOPLEFTALIGN),
       (Ident: 'SBP_THUMBBTNHORZ'; Value: SBP_THUMBBTNHORZ),
       (Ident: 'SCRBS_DISABLED'; Value: SCRBS_DISABLED),
       (Ident: 'SCRBS_HOT'; Value: SCRBS_HOT),
       (Ident: 'SCRBS_HOVER'; Value: SCRBS_HOVER),
       (Ident: 'SCRBS_NORMAL'; Value: SCRBS_NORMAL),
       (Ident: 'SCRBS_PRESSED'; Value: SCRBS_PRESSED),
       (Ident: 'SBP_THUMBBTNVERT'; Value: SBP_THUMBBTNVERT),
       (Ident: 'SCRBS_DISABLED'; Value: SCRBS_DISABLED),
       (Ident: 'SCRBS_HOT'; Value: SCRBS_HOT),
       (Ident: 'SCRBS_HOVER'; Value: SCRBS_HOVER),
       (Ident: 'SCRBS_NORMAL'; Value: SCRBS_NORMAL),
       (Ident: 'SCRBS_PRESSED'; Value: SCRBS_PRESSED),
       (Ident: 'SBP_UPPERTRACKHORZ'; Value: SBP_UPPERTRACKHORZ),
       (Ident: 'SCRBS_DISABLED'; Value: SCRBS_DISABLED),
       (Ident: 'SCRBS_HOT'; Value: SCRBS_HOT),
       (Ident: 'SCRBS_HOVER'; Value: SCRBS_HOVER),
       (Ident: 'SCRBS_NORMAL'; Value: SCRBS_NORMAL),
       (Ident: 'SCRBS_PRESSED'; Value: SCRBS_PRESSED),
       (Ident: 'SBP_UPPERTRACKVERT'; Value: SBP_UPPERTRACKVERT),
       (Ident: 'SCRBS_DISABLED'; Value: SCRBS_DISABLED),
       (Ident: 'SCRBS_HOT'; Value: SCRBS_HOT),
       (Ident: 'SCRBS_HOVER'; Value: SCRBS_HOVER),
       (Ident: 'SCRBS_NORMAL'; Value: SCRBS_NORMAL),
       (Ident: 'SCRBS_PRESSED'; Value: SCRBS_PRESSED),
       (Ident: 'SEBP_SEARCHEDITBOXTEXT'; Value: SEBP_SEARCHEDITBOXTEXT),
       (Ident: 'SEBTS_FORMATTED'; Value: SEBTS_FORMATTED),
       (Ident: 'SPNP_DOWN'; Value: SPNP_DOWN),
       (Ident: 'DNS_DISABLED'; Value: DNS_DISABLED),
       (Ident: 'DNS_HOT'; Value: DNS_HOT),
       (Ident: 'DNS_NORMAL'; Value: DNS_NORMAL),
       (Ident: 'DNS_PRESSED'; Value: DNS_PRESSED),
       (Ident: 'SPNP_DOWNHORZ'; Value: SPNP_DOWNHORZ),
       (Ident: 'DNHZS_DISABLED'; Value: DNHZS_DISABLED),
       (Ident: 'DNHZS_HOT'; Value: DNHZS_HOT),
       (Ident: 'DNHZS_NORMAL'; Value: DNHZS_NORMAL),
       (Ident: 'DNHZS_PRESSED'; Value: DNHZS_PRESSED),
       (Ident: 'SPNP_UP'; Value: SPNP_UP),
       (Ident: 'UPS_DISABLED'; Value: UPS_DISABLED),
       (Ident: 'UPS_HOT'; Value: UPS_HOT),
       (Ident: 'UPS_NORMAL'; Value: UPS_NORMAL),
       (Ident: 'UPS_PRESSED'; Value: UPS_PRESSED),
       (Ident: 'SPNP_UPHORZ'; Value: SPNP_UPHORZ),
       (Ident: 'UPHZS_DISABLED'; Value: UPHZS_DISABLED),
       (Ident: 'UPHZS_HOT'; Value: UPHZS_HOT),
       (Ident: 'UPHZS_NORMAL'; Value: UPHZS_NORMAL),
       (Ident: 'UPHZS_PRESSED'; Value: UPHZS_PRESSED),
       (Ident: 'SPP_LOGOFF'; Value: SPP_LOGOFF),
       (Ident: 'SPP_LOGOFFBUTTONS'; Value: SPP_LOGOFFBUTTONS),
       (Ident: 'SPLS_HOT'; Value: SPLS_HOT),
       (Ident: 'SPLS_NORMAL'; Value: SPLS_NORMAL),
       (Ident: 'SPLS_PRESSED'; Value: SPLS_PRESSED),
       (Ident: 'SPP_MOREPROGRAMS'; Value: SPP_MOREPROGRAMS),
       (Ident: 'SPP_MOREPROGRAMSARROW'; Value: SPP_MOREPROGRAMSARROW),
       (Ident: 'SPS_HOT'; Value: SPS_HOT),
       (Ident: 'SPS_NORMAL'; Value: SPS_NORMAL),
       (Ident: 'SPS_PRESSED'; Value: SPS_PRESSED),
       (Ident: 'SPP_PLACESLIST'; Value: SPP_PLACESLIST),
       (Ident: 'SPP_PLACESLISTSEPARATOR'; Value: SPP_PLACESLISTSEPARATOR),
       (Ident: 'SPP_PREVIEW'; Value: SPP_PREVIEW),
       (Ident: 'SPP_PROGLIST'; Value: SPP_PROGLIST),
       (Ident: 'SPP_PROGLISTSEPARATOR'; Value: SPP_PROGLISTSEPARATOR),
       (Ident: 'SPP_USERPANE'; Value: SPP_USERPANE),
       (Ident: 'SPP_USERPICTURE'; Value: SPP_USERPICTURE),
       (Ident: 'SP_GRIPPER'; Value: SP_GRIPPER),
       (Ident: 'SP_GRIPPERPANE'; Value: SP_GRIPPERPANE),
       (Ident: 'SP_PANE'; Value: SP_PANE),
       (Ident: 'TABP_AEROWIZARDBODY'; Value: TABP_AEROWIZARDBODY),
       (Ident: 'TABP_BODY'; Value: TABP_BODY),
       (Ident: 'TABP_PANE'; Value: TABP_PANE),
       (Ident: 'TABP_TABITEM'; Value: TABP_TABITEM),
       (Ident: 'TIS_DISABLED'; Value: TIS_DISABLED),
       (Ident: 'TIS_FOCUSED'; Value: TIS_FOCUSED),
       (Ident: 'TIS_HOT'; Value: TIS_HOT),
       (Ident: 'TIS_NORMAL'; Value: TIS_NORMAL),
       (Ident: 'TIS_SELECTED'; Value: TIS_SELECTED),
       (Ident: 'TABP_TABITEMBOTHEDGE'; Value: TABP_TABITEMBOTHEDGE),
       (Ident: 'TIBES_DISABLED'; Value: TIBES_DISABLED),
       (Ident: 'TIBES_FOCUSED'; Value: TIBES_FOCUSED),
       (Ident: 'TIBES_HOT'; Value: TIBES_HOT),
       (Ident: 'TIBES_NORMAL'; Value: TIBES_NORMAL),
       (Ident: 'TIBES_SELECTED'; Value: TIBES_SELECTED),
       (Ident: 'TABP_TABITEMLEFTEDGE'; Value: TABP_TABITEMLEFTEDGE),
       (Ident: 'TILES_DISABLED'; Value: TILES_DISABLED),
       (Ident: 'TILES_FOCUSED'; Value: TILES_FOCUSED),
       (Ident: 'TILES_HOT'; Value: TILES_HOT),
       (Ident: 'TILES_NORMAL'; Value: TILES_NORMAL),
       (Ident: 'TILES_SELECTED'; Value: TILES_SELECTED),
       (Ident: 'TABP_TABITEMRIGHTEDGE'; Value: TABP_TABITEMRIGHTEDGE),
       (Ident: 'TIRES_DISABLED'; Value: TIRES_DISABLED),
       (Ident: 'TIRES_FOCUSED'; Value: TIRES_FOCUSED),
       (Ident: 'TIRES_HOT'; Value: TIRES_HOT),
       (Ident: 'TIRES_NORMAL'; Value: TIRES_NORMAL),
       (Ident: 'TIRES_SELECTED'; Value: TIRES_SELECTED),
       (Ident: 'TABP_TOPTABITEM'; Value: TABP_TOPTABITEM),
       (Ident: 'TTIS_DISABLED'; Value: TTIS_DISABLED),
       (Ident: 'TTIS_FOCUSED'; Value: TTIS_FOCUSED),
       (Ident: 'TTIS_HOT'; Value: TTIS_HOT),
       (Ident: 'TTIS_NORMAL'; Value: TTIS_NORMAL),
       (Ident: 'TTIS_SELECTED'; Value: TTIS_SELECTED),
       (Ident: 'TABP_TOPTABITEMBOTHEDGE'; Value: TABP_TOPTABITEMBOTHEDGE),
       (Ident: 'TTIBES_DISABLED'; Value: TTIBES_DISABLED),
       (Ident: 'TTIBES_FOCUSED'; Value: TTIBES_FOCUSED),
       (Ident: 'TTIBES_HOT'; Value: TTIBES_HOT),
       (Ident: 'TTIBES_NORMAL'; Value: TTIBES_NORMAL),
       (Ident: 'TTIBES_SELECTED'; Value: TTIBES_SELECTED),
       (Ident: 'TABP_TOPTABITEMLEFTEDGE'; Value: TABP_TOPTABITEMLEFTEDGE),
       (Ident: 'TTILES_DISABLED'; Value: TTILES_DISABLED),
       (Ident: 'TTILES_FOCUSED'; Value: TTILES_FOCUSED),
       (Ident: 'TTILES_HOT'; Value: TTILES_HOT),
       (Ident: 'TTILES_NORMAL'; Value: TTILES_NORMAL),
       (Ident: 'TTILES_SELECTED'; Value: TTILES_SELECTED),
       (Ident: 'TABP_TOPTABITEMRIGHTEDGE'; Value: TABP_TOPTABITEMRIGHTEDGE),
       (Ident: 'TTIRES_DISABLED'; Value: TTIRES_DISABLED),
       (Ident: 'TTIRES_FOCUSED'; Value: TTIRES_FOCUSED),
       (Ident: 'TTIRES_HOT'; Value: TTIRES_HOT),
       (Ident: 'TTIRES_NORMAL'; Value: TTIRES_NORMAL),
       (Ident: 'TTIRES_SELECTED'; Value: TTIRES_SELECTED),
       (Ident: 'TDP_GROUPCOUNT'; Value: TDP_GROUPCOUNT),
       (Ident: 'TDP_FLASHBUTTON'; Value: TDP_FLASHBUTTON),
       (Ident: 'TDP_FLASHBUTTONGROUPMENU'; Value: TDP_FLASHBUTTONGROUPMENU),
       (Ident: 'TBP_BACKGROUNDBOTTOM'; Value: TBP_BACKGROUNDBOTTOM),
       (Ident: 'TBP_BACKGROUNDLEFT'; Value: TBP_BACKGROUNDLEFT),
       (Ident: 'TBP_BACKGROUNDRIGHT'; Value: TBP_BACKGROUNDRIGHT),
       (Ident: 'TBP_BACKGROUNDTOP'; Value: TBP_BACKGROUNDTOP),
       (Ident: 'TBP_SIZINGBARBOTTOM'; Value: TBP_SIZINGBARBOTTOM),
       (Ident: 'TBP_SIZINGBARBOTTOMLEFT'; Value: TBP_SIZINGBARBOTTOMLEFT),
       (Ident: 'TBP_SIZINGBARRIGHT'; Value: TBP_SIZINGBARRIGHT),
       (Ident: 'TBP_SIZINGBARTOP'; Value: TBP_SIZINGBARTOP),
       (Ident: 'TDLG_BUTTONSECTION'; Value: TDLG_BUTTONSECTION),
       (Ident: 'TDLG_BUTTONWRAPPER'; Value: TDLG_BUTTONWRAPPER),
       (Ident: 'TDLG_COMMANDLINKPANE'; Value: TDLG_COMMANDLINKPANE),
       (Ident: 'TDLG_CONTENTICON'; Value: TDLG_CONTENTICON),
       (Ident: 'TDLG_CONTENTPANE'; Value: TDLG_CONTENTPANE),
       (Ident: 'TDLGCPS_STANDALONE'; Value: TDLGCPS_STANDALONE),
       (Ident: 'TDLG_CONTROLPANE'; Value: TDLG_CONTROLPANE),
       (Ident: 'TDLG_EXPANDEDCONTENT'; Value: TDLG_EXPANDEDCONTENT),
       (Ident: 'TDLG_EXPANDEDFOOTERAREA'; Value: TDLG_EXPANDEDFOOTERAREA),
       (Ident: 'TDLG_EXPANDOBUTTON'; Value: TDLG_EXPANDOBUTTON),
       (Ident: 'TDLGEBS_EXPANDEDHOVER'; Value: TDLGEBS_EXPANDEDHOVER),
       (Ident: 'TDLGEBS_EXPANDEDNORMAL'; Value: TDLGEBS_EXPANDEDNORMAL),
       (Ident: 'TDLGEBS_EXPANDEDPRESSED'; Value: TDLGEBS_EXPANDEDPRESSED),
       (Ident: 'TDLGEBS_HOVER'; Value: TDLGEBS_HOVER),
       (Ident: 'TDLGEBS_NORMAL'; Value: TDLGEBS_NORMAL),
       (Ident: 'TDLGEBS_PRESSED'; Value: TDLGEBS_PRESSED),
       (Ident: 'TDLG_EXPANDOTEXT'; Value: TDLG_EXPANDOTEXT),
       (Ident: 'TDLG_FOOTNOTEAREA'; Value: TDLG_FOOTNOTEAREA),
       (Ident: 'TDLG_FOOTNOTEPANE'; Value: TDLG_FOOTNOTEPANE),
       (Ident: 'TDLG_FOOTNOTESEPARATOR'; Value: TDLG_FOOTNOTESEPARATOR),
       (Ident: 'TDLG_IMAGEALIGNMENT'; Value: TDLG_IMAGEALIGNMENT),
       (Ident: 'TDLG_MAINICON'; Value: TDLG_MAINICON),
       (Ident: 'TDLG_MAININSTRUCTIONPANE'; Value: TDLG_MAININSTRUCTIONPANE),
       (Ident: 'TDLG_PRIMARYPANEL'; Value: TDLG_PRIMARYPANEL),
       (Ident: 'TDLG_PROGRESSBAR'; Value: TDLG_PROGRESSBAR),
       (Ident: 'TDLG_RADIOBUTTONPANE'; Value: TDLG_RADIOBUTTONPANE),
       (Ident: 'TDLG_SECONDARYPANEL'; Value: TDLG_SECONDARYPANEL),
       (Ident: 'TDLG_VERIFICATIONTEXT'; Value: TDLG_VERIFICATIONTEXT),
       (Ident: 'TEXT_BODYTITLE'; Value: TEXT_BODYTITLE),
       (Ident: 'TEXT_BODYTEXT'; Value: TEXT_BODYTEXT),
       (Ident: 'TEXT_CONTROLLABEL'; Value: TEXT_CONTROLLABEL),
       (Ident: 'TS_CONTROLLABEL_DISABLED'; Value: TS_CONTROLLABEL_DISABLED),
       (Ident: 'TS_CONTROLLABEL_NORMAL'; Value: TS_CONTROLLABEL_NORMAL),
       (Ident: 'TEXT_EXPANDED'; Value: TEXT_EXPANDED),
       (Ident: 'TEXT_HYPERLINKTEXT'; Value: TEXT_HYPERLINKTEXT),
       (Ident: 'TS_HYPERLINK_DISABLED'; Value: TS_HYPERLINK_DISABLED),
       (Ident: 'TS_HYPERLINK_HOT'; Value: TS_HYPERLINK_HOT),
       (Ident: 'TS_HYPERLINK_NORMAL'; Value: TS_HYPERLINK_NORMAL),
       (Ident: 'TS_HYPERLINK_PRESSED'; Value: TS_HYPERLINK_PRESSED),
       (Ident: 'TEXT_INSTRUCTION'; Value: TEXT_INSTRUCTION),
       (Ident: 'TEXT_LABEL'; Value: TEXT_LABEL),
       (Ident: 'TEXT_MAININSTRUCTION'; Value: TEXT_MAININSTRUCTION),
       (Ident: 'TEXT_SECONDARYTEXT'; Value: TEXT_SECONDARYTEXT),
       (Ident: 'TP_BUTTON'; Value: TP_BUTTON),
       (Ident: 'TS_CHECKED'; Value: TS_CHECKED),
       (Ident: 'TS_DISABLED'; Value: TS_DISABLED),
       (Ident: 'TS_HOT'; Value: TS_HOT),
       (Ident: 'TS_HOTCHECKED'; Value: TS_HOTCHECKED),
       (Ident: 'TS_NEARHOT'; Value: TS_NEARHOT),
       (Ident: 'TS_NORMAL'; Value: TS_NORMAL),
       (Ident: 'TS_OTHERSIDEHOT'; Value: TS_OTHERSIDEHOT),
       (Ident: 'TS_PRESSED'; Value: TS_PRESSED),
       (Ident: 'TP_DROPDOWNBUTTON'; Value: TP_DROPDOWNBUTTON),
       (Ident: 'TS_CHECKED'; Value: TS_CHECKED),
       (Ident: 'TS_DISABLED'; Value: TS_DISABLED),
       (Ident: 'TS_HOT'; Value: TS_HOT),
       (Ident: 'TS_HOTCHECKED'; Value: TS_HOTCHECKED),
       (Ident: 'TS_NEARHOT'; Value: TS_NEARHOT),
       (Ident: 'TS_NORMAL'; Value: TS_NORMAL),
       (Ident: 'TS_OTHERSIDEHOT'; Value: TS_OTHERSIDEHOT),
       (Ident: 'TS_PRESSED'; Value: TS_PRESSED),
       (Ident: 'TP_DROPDOWNBUTTONGLYPH'; Value: TP_DROPDOWNBUTTONGLYPH),
       (Ident: 'TS_CHECKED'; Value: TS_CHECKED),
       (Ident: 'TS_DISABLED'; Value: TS_DISABLED),
       (Ident: 'TS_HOT'; Value: TS_HOT),
       (Ident: 'TS_HOTCHECKED'; Value: TS_HOTCHECKED),
       (Ident: 'TS_NEARHOT'; Value: TS_NEARHOT),
       (Ident: 'TS_NORMAL'; Value: TS_NORMAL),
       (Ident: 'TS_OTHERSIDEHOT'; Value: TS_OTHERSIDEHOT),
       (Ident: 'TS_PRESSED'; Value: TS_PRESSED),
       (Ident: 'TP_SEPARATOR'; Value: TP_SEPARATOR),
       (Ident: 'TS_CHECKED'; Value: TS_CHECKED),
       (Ident: 'TS_DISABLED'; Value: TS_DISABLED),
       (Ident: 'TS_HOT'; Value: TS_HOT),
       (Ident: 'TS_HOTCHECKED'; Value: TS_HOTCHECKED),
       (Ident: 'TS_NEARHOT'; Value: TS_NEARHOT),
       (Ident: 'TS_NORMAL'; Value: TS_NORMAL),
       (Ident: 'TS_OTHERSIDEHOT'; Value: TS_OTHERSIDEHOT),
       (Ident: 'TS_PRESSED'; Value: TS_PRESSED),
       (Ident: 'TP_SEPARATORVERT'; Value: TP_SEPARATORVERT),
       (Ident: 'TS_CHECKED'; Value: TS_CHECKED),
       (Ident: 'TS_DISABLED'; Value: TS_DISABLED),
       (Ident: 'TS_HOT'; Value: TS_HOT),
       (Ident: 'TS_HOTCHECKED'; Value: TS_HOTCHECKED),
       (Ident: 'TS_NEARHOT'; Value: TS_NEARHOT),
       (Ident: 'TS_NORMAL'; Value: TS_NORMAL),
       (Ident: 'TS_OTHERSIDEHOT'; Value: TS_OTHERSIDEHOT),
       (Ident: 'TS_PRESSED'; Value: TS_PRESSED),
       (Ident: 'TP_SPLITBUTTON'; Value: TP_SPLITBUTTON),
       (Ident: 'TS_CHECKED'; Value: TS_CHECKED),
       (Ident: 'TS_DISABLED'; Value: TS_DISABLED),
       (Ident: 'TS_HOT'; Value: TS_HOT),
       (Ident: 'TS_HOTCHECKED'; Value: TS_HOTCHECKED),
       (Ident: 'TS_NEARHOT'; Value: TS_NEARHOT),
       (Ident: 'TS_NORMAL'; Value: TS_NORMAL),
       (Ident: 'TS_OTHERSIDEHOT'; Value: TS_OTHERSIDEHOT),
       (Ident: 'TS_PRESSED'; Value: TS_PRESSED),
       (Ident: 'TP_SPLITBUTTONDROPDOWN'; Value: TP_SPLITBUTTONDROPDOWN),
       (Ident: 'TS_CHECKED'; Value: TS_CHECKED),
       (Ident: 'TS_DISABLED'; Value: TS_DISABLED),
       (Ident: 'TS_HOT'; Value: TS_HOT),
       (Ident: 'TS_HOTCHECKED'; Value: TS_HOTCHECKED),
       (Ident: 'TS_NEARHOT'; Value: TS_NEARHOT),
       (Ident: 'TS_NORMAL'; Value: TS_NORMAL),
       (Ident: 'TS_OTHERSIDEHOT'; Value: TS_OTHERSIDEHOT),
       (Ident: 'TS_PRESSED'; Value: TS_PRESSED),
       (Ident: 'TTP_BALLOON'; Value: TTP_BALLOON),
       (Ident: 'TTBS_LINK'; Value: TTBS_LINK),
       (Ident: 'TTBS_NORMAL'; Value: TTBS_NORMAL),
       (Ident: 'TTP_BALLOONSTEM'; Value: TTP_BALLOONSTEM),
       (Ident: 'TTBSS_POINTINGUPLEFTWALL'; Value: TTBSS_POINTINGUPLEFTWALL),
       (Ident: 'TTBSS_POINTINGUPCENTERED'; Value: TTBSS_POINTINGUPCENTERED),
       (Ident: 'TTBSS_POINTINGUPRIGHTWALL'; Value: TTBSS_POINTINGUPRIGHTWALL),
       (Ident: 'TTBSS_POINTINGDOWNRIGHTWALL'; Value: TTBSS_POINTINGDOWNRIGHTWALL),
       (Ident: 'TTBSS_POINTINGDOWNCENTERED'; Value: TTBSS_POINTINGDOWNCENTERED),
       (Ident: 'TTBSS_POINTINGDOWNLEFTWALL'; Value: TTBSS_POINTINGDOWNLEFTWALL),
       (Ident: 'TTP_BALLOONTITLE'; Value: TTP_BALLOONTITLE),
       (Ident: 'TTP_CLOSE'; Value: TTP_CLOSE),
       (Ident: 'TTCS_HOT'; Value: TTCS_HOT),
       (Ident: 'TTCS_NORMAL'; Value: TTCS_NORMAL),
       (Ident: 'TTCS_PRESSED'; Value: TTCS_PRESSED),
       (Ident: 'TTP_STANDARD'; Value: TTP_STANDARD),
       (Ident: 'TTSS_LINK'; Value: TTSS_LINK),
       (Ident: 'TTSS_NORMAL'; Value: TTSS_NORMAL),
       (Ident: 'TTP_STANDARDTITLE'; Value: TTP_STANDARDTITLE),
       (Ident: 'TTSS_LINK'; Value: TTSS_LINK),
       (Ident: 'TTSS_NORMAL'; Value: TTSS_NORMAL),
       (Ident: 'TTP_WRENCH'; Value: TTP_WRENCH),
       (Ident: 'TTWS_NORMAL'; Value: TTWS_NORMAL),
       (Ident: 'TTWS_HOT'; Value: TTWS_HOT),
       (Ident: 'TTWS_PRESSED'; Value: TTWS_PRESSED),
       (Ident: 'TKP_THUMB'; Value: TKP_THUMB),
       (Ident: 'TUS_DISABLED'; Value: TUS_DISABLED),
       (Ident: 'TUS_FOCUSED'; Value: TUS_FOCUSED),
       (Ident: 'TUS_HOT'; Value: TUS_HOT),
       (Ident: 'TUS_NORMAL'; Value: TUS_NORMAL),
       (Ident: 'TUS_PRESSED'; Value: TUS_PRESSED),
       (Ident: 'TKP_THUMBBOTTOM'; Value: TKP_THUMBBOTTOM),
       (Ident: 'TUBS_DISABLED'; Value: TUBS_DISABLED),
       (Ident: 'TUBS_FOCUSED'; Value: TUBS_FOCUSED),
       (Ident: 'TUBS_HOT'; Value: TUBS_HOT),
       (Ident: 'TUBS_NORMAL'; Value: TUBS_NORMAL),
       (Ident: 'TUBS_PRESSED'; Value: TUBS_PRESSED),
       (Ident: 'TKP_THUMBLEFT'; Value: TKP_THUMBLEFT),
       (Ident: 'TUVLS_DISABLED'; Value: TUVLS_DISABLED),
       (Ident: 'TUVLS_FOCUSED'; Value: TUVLS_FOCUSED),
       (Ident: 'TUVLS_HOT'; Value: TUVLS_HOT),
       (Ident: 'TUVLS_NORMAL'; Value: TUVLS_NORMAL),
       (Ident: 'TUVLS_PRESSED'; Value: TUVLS_PRESSED),
       (Ident: 'TKP_THUMBRIGHT'; Value: TKP_THUMBRIGHT),
       (Ident: 'TUVRS_DISABLED'; Value: TUVRS_DISABLED),
       (Ident: 'TUVRS_FOCUSED'; Value: TUVRS_FOCUSED),
       (Ident: 'TUVRS_HOT'; Value: TUVRS_HOT),
       (Ident: 'TUVRS_NORMAL'; Value: TUVRS_NORMAL),
       (Ident: 'TUVRS_PRESSED'; Value: TUVRS_PRESSED),
       (Ident: 'TKP_THUMBTOP'; Value: TKP_THUMBTOP),
       (Ident: 'TUTS_DISABLED'; Value: TUTS_DISABLED),
       (Ident: 'TUTS_FOCUSED'; Value: TUTS_FOCUSED),
       (Ident: 'TUTS_HOT'; Value: TUTS_HOT),
       (Ident: 'TUTS_NORMAL'; Value: TUTS_NORMAL),
       (Ident: 'TUTS_PRESSED'; Value: TUTS_PRESSED),
       (Ident: 'TKP_THUMBVERT'; Value: TKP_THUMBVERT),
       (Ident: 'TUVS_DISABLED'; Value: TUVS_DISABLED),
       (Ident: 'TUVS_FOCUSED'; Value: TUVS_FOCUSED),
       (Ident: 'TUVS_HOT'; Value: TUVS_HOT),
       (Ident: 'TUVS_NORMAL'; Value: TUVS_NORMAL),
       (Ident: 'TUVS_PRESSED'; Value: TUVS_PRESSED),
       (Ident: 'TKP_TICS'; Value: TKP_TICS),
       (Ident: 'TSS_NORMAL'; Value: TSS_NORMAL),
       (Ident: 'TKP_TICSVERT'; Value: TKP_TICSVERT),
       (Ident: 'TSVS_NORMAL'; Value: TSVS_NORMAL),
       (Ident: 'TKP_TRACK'; Value: TKP_TRACK),
       (Ident: 'TRS_NORMAL'; Value: TRS_NORMAL),
       (Ident: 'TKP_TRACKVERT'; Value: TKP_TRACKVERT),
       (Ident: 'TRVS_NORMAL'; Value: TRVS_NORMAL),
       (Ident: 'TNP_ANIMBACKGROUND'; Value: TNP_ANIMBACKGROUND),
       (Ident: 'TNP_BACKGROUND'; Value: TNP_BACKGROUND),
       (Ident: 'TVP_BRANCH'; Value: TVP_BRANCH),
       (Ident: 'TVP_GLYPH'; Value: TVP_GLYPH),
       (Ident: 'GLPS_CLOSED'; Value: GLPS_CLOSED),
       (Ident: 'GLPS_OPENED'; Value: GLPS_OPENED),
       (Ident: 'TVP_HOTGLYPH'; Value: TVP_HOTGLYPH),
       (Ident: 'HGLPS_CLOSED'; Value: HGLPS_CLOSED),
       (Ident: 'HGLPS_OPENED'; Value: HGLPS_OPENED),
       (Ident: 'TVP_TREEITEM'; Value: TVP_TREEITEM),
       (Ident: 'TREIS_DISABLED'; Value: TREIS_DISABLED),
       (Ident: 'TREIS_HOT'; Value: TREIS_HOT),
       (Ident: 'TREIS_NORMAL'; Value: TREIS_NORMAL),
       (Ident: 'TREIS_SELECTED'; Value: TREIS_SELECTED),
       (Ident: 'TREIS_SELECTEDNOTFOCUS'; Value: TREIS_SELECTEDNOTFOCUS),
       (Ident: 'TREIS_HOTSELECTED'; Value: TREIS_HOTSELECTED),
       (Ident: 'WP_CAPTION'; Value: WP_CAPTION),
       (Ident: 'CS_ACTIVE'; Value: CS_ACTIVE),
       (Ident: 'CS_DISABLED'; Value: CS_DISABLED),
       (Ident: 'CS_INACTIVE'; Value: CS_INACTIVE),
       (Ident: 'WP_CAPTIONSIZINGTEMPLATE'; Value: WP_CAPTIONSIZINGTEMPLATE),
       (Ident: 'WP_CLOSEBUTTON'; Value: WP_CLOSEBUTTON),
       (Ident: 'CBS_DISABLED'; Value: CBS_DISABLED),
       (Ident: 'CBS_HOT'; Value: CBS_HOT),
       (Ident: 'CBS_NORMAL'; Value: CBS_NORMAL),
       (Ident: 'CBS_PUSHED'; Value: CBS_PUSHED),
       (Ident: 'WP_DIALOG'; Value: WP_DIALOG),
       (Ident: 'WP_FRAME'; Value: WP_FRAME),
       (Ident: 'FS_ACTIVE'; Value: FS_ACTIVE),
       (Ident: 'FS_INACTIVE'; Value: FS_INACTIVE),
       (Ident: 'WP_FRAMEBOTTOM'; Value: WP_FRAMEBOTTOM),
       (Ident: 'WP_FRAMEBOTTOMSIZINGTEMPLATE'; Value: WP_FRAMEBOTTOMSIZINGTEMPLATE),
       (Ident: 'WP_FRAMELEFT'; Value: WP_FRAMELEFT),
       (Ident: 'WP_FRAMELEFTSIZINGTEMPLATE'; Value: WP_FRAMELEFTSIZINGTEMPLATE),
       (Ident: 'WP_FRAMERIGHT'; Value: WP_FRAMERIGHT),
       (Ident: 'WP_FRAMERIGHTSIZINGTEMPLATE'; Value: WP_FRAMERIGHTSIZINGTEMPLATE),
       (Ident: 'WP_HELPBUTTON'; Value: WP_HELPBUTTON),
       (Ident: 'HBS_DISABLED'; Value: HBS_DISABLED),
       (Ident: 'HBS_HOT'; Value: HBS_HOT),
       (Ident: 'HBS_NORMAL'; Value: HBS_NORMAL),
       (Ident: 'HBS_PUSHED'; Value: HBS_PUSHED),
       (Ident: 'WP_HORZSCROLL'; Value: WP_HORZSCROLL),
       (Ident: 'HSS_DISABLED'; Value: HSS_DISABLED),
       (Ident: 'HSS_HOT'; Value: HSS_HOT),
       (Ident: 'HSS_NORMAL'; Value: HSS_NORMAL),
       (Ident: 'HSS_PUSHED'; Value: HSS_PUSHED),
       (Ident: 'WP_HORZTHUMB'; Value: WP_HORZTHUMB),
       (Ident: 'HTS_DISABLED'; Value: HTS_DISABLED),
       (Ident: 'HTS_HOT'; Value: HTS_HOT),
       (Ident: 'HTS_NORMAL'; Value: HTS_NORMAL),
       (Ident: 'HTS_PUSHED'; Value: HTS_PUSHED),
       (Ident: 'WP_MAXBUTTON'; Value: WP_MAXBUTTON),
       (Ident: 'MAXBS_DISABLED'; Value: MAXBS_DISABLED),
       (Ident: 'MAXBS_HOT'; Value: MAXBS_HOT),
       (Ident: 'MAXBS_NORMAL'; Value: MAXBS_NORMAL),
       (Ident: 'MAXBS_PUSHED'; Value: MAXBS_PUSHED),
       (Ident: 'WP_MAXCAPTION'; Value: WP_MAXCAPTION),
       (Ident: 'MXCS_ACTIVE'; Value: MXCS_ACTIVE),
       (Ident: 'MXCS_DISABLED'; Value: MXCS_DISABLED),
       (Ident: 'MXCS_INACTIVE'; Value: MXCS_INACTIVE),
       (Ident: 'WP_MDICLOSEBUTTON'; Value: WP_MDICLOSEBUTTON),
       (Ident: 'WP_MDIHELPBUTTON'; Value: WP_MDIHELPBUTTON),
       (Ident: 'WP_MDIMINBUTTON'; Value: WP_MDIMINBUTTON),
       (Ident: 'WP_MDIRESTOREBUTTON'; Value: WP_MDIRESTOREBUTTON),
       (Ident: 'WP_MDISYSBUTTON'; Value: WP_MDISYSBUTTON),
       (Ident: 'WP_MINBUTTON'; Value: WP_MINBUTTON),
       (Ident: 'MINBS_DISABLED'; Value: MINBS_DISABLED),
       (Ident: 'MINBS_HOT'; Value: MINBS_HOT),
       (Ident: 'MINBS_NORMAL'; Value: MINBS_NORMAL),
       (Ident: 'MINBS_PUSHED'; Value: MINBS_PUSHED),
       (Ident: 'WP_MINCAPTION'; Value: WP_MINCAPTION),
       (Ident: 'MNCS_ACTIVE'; Value: MNCS_ACTIVE),
       (Ident: 'MNCS_DISABLED'; Value: MNCS_DISABLED),
       (Ident: 'MNCS_INACTIVE'; Value: MNCS_INACTIVE),
       (Ident: 'WP_RESTOREBUTTON'; Value: WP_RESTOREBUTTON),
       (Ident: 'RBS_DISABLED'; Value: RBS_DISABLED),
       (Ident: 'RBS_HOT'; Value: RBS_HOT),
       (Ident: 'RBS_NORMAL'; Value: RBS_NORMAL),
       (Ident: 'RBS_PUSHED'; Value: RBS_PUSHED),
       (Ident: 'WP_SMALLCAPTION'; Value: WP_SMALLCAPTION),
       (Ident: 'WP_SMALLCAPTIONSIZINGTEMPLATE'; Value: WP_SMALLCAPTIONSIZINGTEMPLATE),
       (Ident: 'WP_SMALLCLOSEBUTTON'; Value: WP_SMALLCLOSEBUTTON),
       (Ident: 'WP_SMALLFRAMEBOTTOM'; Value: WP_SMALLFRAMEBOTTOM),
       (Ident: 'WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE'; Value: WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE),
       (Ident: 'WP_SMALLFRAMELEFT'; Value: WP_SMALLFRAMELEFT),
       (Ident: 'WP_SMALLFRAMELEFTSIZINGTEMPLATE'; Value: WP_SMALLFRAMELEFTSIZINGTEMPLATE),
       (Ident: 'WP_SMALLFRAMERIGHT'; Value: WP_SMALLFRAMERIGHT),
       (Ident: 'WP_SMALLFRAMERIGHTSIZINGTEMPLATE'; Value: WP_SMALLFRAMERIGHTSIZINGTEMPLATE),
       (Ident: 'WP_SMALLMAXCAPTION'; Value: WP_SMALLMAXCAPTION),
       (Ident: 'WP_SMALLMINCAPTION'; Value: WP_SMALLMINCAPTION),
       (Ident: 'WP_SYSBUTTON'; Value: WP_SYSBUTTON),
       (Ident: 'SBS_DISABLED'; Value: SBS_DISABLED),
       (Ident: 'SBS_HOT'; Value: SBS_HOT),
       (Ident: 'SBS_NORMAL'; Value: SBS_NORMAL),
       (Ident: 'SBS_PUSHED'; Value: SBS_PUSHED),
       (Ident: 'WP_VERTSCROLL'; Value: WP_VERTSCROLL),
       (Ident: 'VSS_DISABLED'; Value: VSS_DISABLED),
       (Ident: 'VSS_HOT'; Value: VSS_HOT),
       (Ident: 'VSS_NORMAL'; Value: VSS_NORMAL),
       (Ident: 'VSS_PUSHED'; Value: VSS_PUSHED),
       (Ident: 'WP_VERTTHUMB'; Value: WP_VERTTHUMB),
       (Ident: 'VTS_DISABLED'; Value: VTS_DISABLED),
       (Ident: 'VTS_HOT'; Value: VTS_HOT),
       (Ident: 'VTS_NORMAL'; Value: VTS_NORMAL),
       (Ident: 'VTS_PUSHED'; Value: VTS_PUSHED));

type
  TNodeWithChildren = record
    Node: string;
    Children: string;
  end;

const
  ClassesWithParts: array[0..35] of TNodeWithChildren =
    ((Node: 'BUTTON'; Children: 'BP_CHECKBOX,BP_COMMANDLINK,BP_COMMANDLINKGLYPH,BP_GROUPBOX,BP_PUSHBUTTON,BP_RADIOBUTTON,BP_USERBUTTON'),
    (Node: 'CLOCK'; Children: 'CLP_TIME'),
    (Node: 'COMBOBOX'; Children: 'CP_BACKGROUND,CP_BORDER,CP_CUEBANNER,CP_DROPDOWNBUTTON,CP_DROPDOWNBUTTONLEFT,CP_DROPDOWNBUTTONRIGHT,CP_TRANSPARENTBACKGROUND,CP_READONLY'),
    (Node: 'COMMUNICATIONS'; Children: 'CSST_TAB'),
    (Node: 'CONTROLPANEL'; Children: 'CPANEL_BANNERAREA,CPANEL_BODYTEXT,CPANEL_BODYTITLE,CPANEL_BUTTON,CPANEL_CONTENTLINK,CPANEL_CONTENTPANE,CPANEL_CONTENTPANELABEL,'+'CPANEL_CONTENTPANELINE,CPANEL_GROUPTEXT,CPANEL_HELPLINK,CPANEL_LARGECOMMANDAREA,CPANEL_MESSAGETEXT,CPANEL_NAVIGATIONPANE,CPANEL_NAVIGATIONPANELABEL,CPANEL_NAVIGATIONPANELINE,CPANEL_SECTIONTITLELINK,CPANEL_SMALLCOMMANDAREA,CPANEL_TASKLINK,CPANEL_TITLE'),
    (Node: 'DATEPICKER'; Children: 'DP_DATEBORDER,DP_DATETEXT,DP_SHOWCALENDARBUTTONRIGHT'),
    (Node: 'DRAGDROP'; Children: 'DD_COPY,DD_CREATELINK,DD_IMAGEBG,DD_MOVE,DD_NONE,DD_TEXTBG,DD_UPDATEMETADATA,DD_WARNING'),
    (Node: 'EDIT'; Children: 'EP_BACKGROUND,EP_BACKGROUNDWITHBORDER,EP_CARET,EP_EDITBORDER_HSCROLL,EP_EDITBORDER_HVSCROLL,EP_EDITBORDER_NOSCROLL,EP_EDITBORDER_VSCROLL,EP_EDITTEXT,EP_PASSWORD'),
    (Node: 'EXPLORERBAR'; Children: 'EBP_HEADERBACKGROUND,EBP_HEADERCLOSE,EBP_HEADERPIN,EBP_IEBARMENU,EBP_NORMALGROUPBACKGROUND,EBP_NORMALGROUPCOLLAPSE,EBP_NORMALGROUPEXPAND,EBP_NORMALGROUPHEAD,EBP_SPECIALGROUPBACKGROUND,EBP_SPECIALGROUPCOLLAPSE,EBP_SPECIALGROUPEXPAND,EBP_SPECIALGROUPHEAD'),
    (Node: 'FLYOUT'; Children: 'FLYOUT_BODY,FLYOUT_DIVIDER,FLYOUT_HEADER,FLYOUT_LABEL,FLYOUT_LINK,FLYOUT_LINKAREA,FLYOUT_LINKHEADER,FLYOUT_WINDOW'),
    (Node: 'GLOBALS'; Children: 'GP_BORDER,GP_LINEHORZ,GP_LINEVERT'),
    (Node: 'HEADER'; Children: 'HP_HEADERDROPDOWN,HP_HEADERDROPDOWNFILTER,HP_HEADERITEM,HP_HEADERITEMLEFT,HP_HEADERITEMRIGHT,HP_HEADEROVERFLOW,HP_HEADERSORTARROW'),
    (Node: 'LISTBOX'; Children: 'LBCP_BORDER_HSCROLL,LBCP_BORDER_HVSCROLL,LBCP_BORDER_NOSCROLL,LBCP_BORDER_VSCROLL,LBCP_ITEM'),
    (Node: 'LISTVIEW'; Children: 'LVP_COLLAPSEBUTTON,LVP_COLUMNDETAIL,LVP_EMPTYTEXT,LVP_EXPANDBUTTON,LVP_GROUPHEADER,LVP_GROUPHEADERLINE,LVP_LISTGROUP,LVP_LISTDETAIL,LVP_LISTITEM,LVP_LISTSORTEDDETAIL'),
    (Node: 'MENU'; Children: 'MENU_BARBACKGROUND,MENU_BARITEM,MENU_CHEVRON_TMSCHEMA,MENU_MENUBARDROPDOWN_TMSCHEMA,MENU_MENUBARITEM_TMSCHEMA,'+'MENU_MENUDROPDOWN_TMSCHEMA,MENU_MENUITEM_TMSCHEMA,MENU_POPUPBACKGROUND,MENU_POPUPBORDERS,MENU_POPUPCHECK,MENU_POPUPCHECKBACKGROUND,MENU_POPUPGUTTER,MENU_POPUPITEM,MENU_POPUPSEPARATOR,MENU_POPUPSUBMENU,'+'MENU_SEPARATOR_TMSCHEMA,MENU_SYSTEMCLOSE,MENU_SYSTEMMAXIMIZE,MENU_SYSTEMMINIMIZE,MENU_SYSTEMRESTORE'),
    (Node: 'MENUBAND'; Children: 'MDP_NEWAPPBUTTON,MDP_SEPERATOR'),
    (Node: 'NAVIGATION'; Children: 'NAV_BACKBUTTON,NAV_FORWARDBUTTON,NAV_MENUBUTTON'),
    (Node: 'PAGE'; Children: 'PGRP_DOWN,PGRP_DOWNHORZ,PGRP_UP,PGRP_UPHORZ'),
    (Node: 'PROGRESS'; Children: 'PP_BAR,PP_BARVERT,PP_CHUNK,PP_CHUNKVERT,PP_FILL,PP_FILLVERT,PP_MOVEOVERLAY,PP_MOVEOVERLAYVERT,PP_PULSEOVERLAY,PP_PULSEOVERLAYVERT,PP_TRANSPARENTBAR,PP_TRANSPARENTBARVERT'),
    (Node: 'REBAR'; Children: 'RP_BACKGROUND,RP_BAND,RP_CHEVRON,RP_CHEVRONVERT,RP_GRIPPER,RP_GRIPPERVERT,RP_SPLITTER,RP_SPLITTERVERT'),
    (Node: 'SCROLLBAR'; Children: 'SBP_ARROWBTN,SBP_GRIPPERHORZ,SBP_GRIPPERVERT,SBP_LOWERTRACKHORZ,SBP_LOWERTRACKVERT,SBP_SIZEBOX,SBP_THUMBBTNHORZ,SBP_THUMBBTNVERT,SBP_UPPERTRACKHORZ,SBP_UPPERTRACKVERT'),
    (Node: 'SEARCHEDITBOX'; Children: 'SEBP_SEARCHEDITBOXTEXT'),
    (Node: 'SPIN'; Children: 'SPNP_DOWN,SPNP_DOWNHORZ,SPNP_UP,SPNP_UPHORZ'),
    (Node: 'STARTPANEL'; Children: 'SPP_LOGOFF,SPP_LOGOFFBUTTONS,SPP_MOREPROGRAMS,SPP_MOREPROGRAMSARROW,SPP_PLACESLIST,SPP_PLACESLISTSEPARATOR,SPP_PREVIEW,SPP_PROGLIST,SPP_PROGLISTSEPARATOR,SPP_USERPANE,SPP_USERPICTURE'),
    (Node: 'STATUS'; Children: 'SP_GRIPPER,SP_GRIPPERPANE,SP_PANE'),
    (Node: 'TAB'; Children: 'TABP_AEROWIZARDBODY,TABP_BODY,TABP_PANE,TABP_TABITEM,TABP_TABITEMBOTHEDGE,TABP_TABITEMLEFTEDGE,TABP_TABITEMRIGHTEDGE,TABP_TOPTABITEM,TABP_TOPTABITEMBOTHEDGE,TABP_TOPTABITEMLEFTEDGE,TABP_TOPTABITEMRIGHTEDGE'),
    (Node: 'TASKBAND'; Children: 'TDP_GROUPCOUNT,TDP_FLASHBUTTON,TDP_FLASHBUTTONGROUPMENU'),
    (Node: 'TASKBAR'; Children: 'TBP_BACKGROUNDBOTTOM,TBP_BACKGROUNDLEFT,TBP_BACKGROUNDRIGHT,TBP_BACKGROUNDTOP,TBP_SIZINGBARBOTTOM,TBP_SIZINGBARBOTTOMLEFT,TBP_SIZINGBARRIGHT,TBP_SIZINGBARTOP'),
    (Node: 'TASKDIALOG'; Children: 'TDLG_BUTTONSECTION,TDLG_BUTTONWRAPPER,TDLG_COMMANDLINKPANE,TDLG_CONTENTICON,TDLG_CONTENTPANE,TDLG_CONTROLPANE,TDLG_EXPANDEDCONTENT,'+'TDLG_EXPANDEDFOOTERAREA,TDLG_EXPANDOBUTTON,TDLG_EXPANDOTEXT,TDLG_FOOTNOTEAREA,TDLG_FOOTNOTEPANE,TDLG_FOOTNOTESEPARATOR,TDLG_IMAGEALIGNMENT,'+'TDLG_MAINICON,TDLG_MAININSTRUCTIONPANE,TDLG_PRIMARYPANEL,TDLG_PROGRESSBAR,TDLG_RADIOBUTTONPANE,TDLG_SECONDARYPANEL,TDLG_VERIFICATIONTEXT'),
    (Node: 'TEXTSTYLE'; Children: 'TEXT_BODYTITLE,TEXT_BODYTEXT,TEXT_CONTROLLABEL,TEXT_EXPANDED,TEXT_HYPERLINKTEXT,TEXT_INSTRUCTION,TEXT_LABEL,TEXT_MAININSTRUCTION,TEXT_SECONDARYTEXT'),
    (Node: 'TOOLBAR'; Children: 'TP_BUTTON,TP_DROPDOWNBUTTON,TP_DROPDOWNBUTTONGLYPH,TP_SEPARATOR,TP_SEPARATORVERT,TP_SPLITBUTTON,TP_SPLITBUTTONDROPDOWN'),
    (Node: 'TOOLTIP'; Children: 'TTP_BALLOON,TTP_BALLOONSTEM,TTP_BALLOONTITLE,TTP_CLOSE,TTP_STANDARD,TTP_STANDARDTITLE,TTP_WRENCH'),
    (Node: 'TRACKBAR'; Children: 'TKP_THUMB,TKP_THUMBBOTTOM,TKP_THUMBLEFT,TKP_THUMBRIGHT,TKP_THUMBTOP,TKP_THUMBVERT,TKP_TICS,TKP_TICSVERT,TKP_TRACK,TKP_TRACKVERT'),
    (Node: 'TRAYNOTIFY'; Children: 'TNP_ANIMBACKGROUND,TNP_BACKGROUND'),
    (Node: 'TREEVIEW'; Children: 'TVP_BRANCH,TVP_GLYPH,TVP_HOTGLYPH,TVP_TREEITEM'),
    (Node: 'WINDOW'; Children: 'WP_CAPTION,WP_CAPTIONSIZINGTEMPLATE,WP_CLOSEBUTTON,WP_DIALOG,WP_FRAME,WP_FRAMEBOTTOM,WP_FRAMEBOTTOMSIZINGTEMPLATE,'+'WP_FRAMELEFT,WP_FRAMELEFTSIZINGTEMPLATE,WP_FRAMERIGHT,WP_FRAMERIGHTSIZINGTEMPLATE,WP_HELPBUTTON,WP_HORZSCROLL,WP_HORZTHUMB,'+'WP_MAXBUTTON,WP_MAXCAPTION,WP_MDICLOSEBUTTON,WP_MDIHELPBUTTON,WP_MDIMINBUTTON,WP_MDIRESTOREBUTTON,WP_MDISYSBUTTON,WP_MINBUTTON,WP_MINCAPTION,WP_RESTOREBUTTON,WP_SMALLCAPTION,WP_SMALLCAPTIONSIZINGTEMPLATE,'+'WP_SMALLCLOSEBUTTON,WP_SMALLFRAMEBOTTOM,WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE,WP_SMALLFRAMELEFT,WP_SMALLFRAMELEFTSIZINGTEMPLATE,WP_SMALLFRAMERIGHT,WP_SMALLFRAMERIGHTSIZINGTEMPLATE,'+'WP_SMALLMAXCAPTION,WP_SMALLMINCAPTION,WP_SYSBUTTON,WP_VERTSCROLL,WP_VERTTHUMB'));

  PartsWithStates: array[0..298] of TNodeWithChildren =
    ((Node: 'BP_CHECKBOX'; Children: 'CBS_CHECKEDDISABLED,CBS_CHECKEDHOT,CBS_CHECKEDNORMAL,CBS_CHECKEDPRESSED,CBS_MIXEDDISABLED,CBS_MIXEDHOT,CBS_MIXEDNORMAL,CBS_MIXEDPRESSED,CBS_UNCHECKEDDISABLED,CBS_UNCHECKEDHOT,CBS_UNCHECKEDNORMAL,CBS_UNCHECKEDPRESSED'),
    (Node: 'BP_COMMANDLINK'; Children: 'CMDLS_DEFAULTED,CMDLS_DEFAULTED_ANIMATING,CMDLS_DISABLED,CMDLS_HOT,CMDLS_NORMAL,CMDLS_PRESSED'),
    (Node: 'BP_COMMANDLINKGLYPH'; Children: 'CMDLGS_DEFAULTED,CMDLGS_DISABLED,CMDLGS_HOT,CMDLGS_NORMAL,CMDLGS_PRESSED'),
    (Node: 'BP_GROUPBOX'; Children: 'GBS_DISABLED,GBS_NORMAL'),
    (Node: 'BP_PUSHBUTTON'; Children: 'PBS_DEFAULTED,PBS_DISABLED,PBS_HOT,PBS_NORMAL,PBS_PRESSED'),
    (Node: 'BP_RADIOBUTTON'; Children: 'RBS_CHECKEDDISABLED,RBS_CHECKEDHOT,RBS_CHECKEDNORMAL,RBS_CHECKEDPRESSED,RBS_UNCHECKEDDISABLED,RBS_UNCHECKEDHOT,RBS_UNCHECKEDNORMAL,RBS_UNCHECKEDPRESSED'),
    (Node: 'BP_USERBUTTON'; Children: ''),
    (Node: 'CLP_TIME'; Children: 'CLS_NORMAL,CLS_HOT,CLS_PRESSED'),
    (Node: 'CP_BACKGROUND'; Children: ''),
    (Node: 'CP_BORDER'; Children: 'CBB_DISABLED,CBB_FOCUSED,CBB_HOT,CBB_NORMAL'),
    (Node: 'CP_CUEBANNER'; Children: 'CBCB_DISABLED,CBCB_HOT,CBCB_NORMAL,CBCB_PRESSED'),
    (Node: 'CP_DROPDOWNBUTTON'; Children: 'CBXS_DISABLED,CBXS_HOT,CBXS_NORMAL,CBXS_PRESSED'),
    (Node: 'CP_DROPDOWNBUTTONLEFT'; Children: 'CBXSL_DISABLED,CBXSL_HOT,CBXSL_NORMAL,CBXSL_PRESSED'),
    (Node: 'CP_DROPDOWNBUTTONRIGHT'; Children: 'CBXSR_DISABLED,CBXSR_HOT,CBXSR_NORMAL,CBXSR_PRESSED'),
    (Node: 'CP_TRANSPARENTBACKGROUND'; Children: 'CBTBS_DISABLED,CBTBS_FOCUSED,CBTBS_HOT,CBTBS_NORMAL'),
    (Node: 'CP_READONLY'; Children: 'CBRO_DISABLED,CBRO_HOT,CBRO_NORMAL,CBRO_PRESSED'),
    (Node: 'CSST_TAB'; Children: 'CSTB_HOT,CSTB_NORMAL,CSTB_SELECTED'),
    (Node: 'CPANEL_BANNERAREA'; Children: ''),
    (Node: 'CPANEL_BODYTEXT'; Children: ''),
    (Node: 'CPANEL_BODYTITLE'; Children: ''),
    (Node: 'CPANEL_BUTTON'; Children: ''),
    (Node: 'CPANEL_CONTENTLINK'; Children: 'CPCL_DISABLED,CPCL_HOT,CPCL_NORMAL,CPCL_PRESSED'),
    (Node: 'CPANEL_CONTENTPANE'; Children: ''),
    (Node: 'CPANEL_CONTENTPANELABEL'; Children: ''),
    (Node: 'CPANEL_CONTENTPANELINE'; Children: ''),
    (Node: 'CPANEL_GROUPTEXT'; Children: ''),
    (Node: 'CPANEL_HELPLINK'; Children: 'CPHL_DISABLED,CPHL_HOT,CPHL_NORMAL,CPHL_PRESSED'),
    (Node: 'CPANEL_LARGECOMMANDAREA'; Children: ''),
    (Node: 'CPANEL_MESSAGETEXT'; Children: ''),
    (Node: 'CPANEL_NAVIGATIONPANE'; Children: ''),
    (Node: 'CPANEL_NAVIGATIONPANELABEL'; Children: ''),
    (Node: 'CPANEL_NAVIGATIONPANELINE'; Children: ''),
    (Node: 'CPANEL_SECTIONTITLELINK'; Children: 'CPSTL_HOT,CPSTL_NORMAL'),
    (Node: 'CPANEL_SMALLCOMMANDAREA'; Children: ''),
    (Node: 'CPANEL_TASKLINK'; Children: 'CPTL_DISABLED,CPTL_HOT,CPTL_NORMAL,CPTL_PAGE,CPTL_PRESSED'),
    (Node: 'CPANEL_TITLE'; Children: ''),
    (Node: 'DP_DATEBORDER'; Children: 'DPDB_DISABLED,DPDB_FOCUSED,DPDB_HOT,DPDB_NORMAL'),
    (Node: 'DP_DATETEXT'; Children: 'DPDT_DISABLED,DPDT_NORMAL,DPDT_SELECTED'),
    (Node: 'DP_SHOWCALENDARBUTTONRIGHT'; Children: 'DPSCBR_DISABLED,DPSCBR_HOT,DPSCBR_NORMAL,DPSCBR_PRESSED'),
    (Node: 'DD_COPY'; Children: 'DDCOPY_HIGHLIGHT,DDCOPY_NOHIGHLIGHT'),
    (Node: 'DD_CREATELINK'; Children: 'DDCREATELINK_HIGHLIGHT,DDCREATELINK_NOHIGHLIGHT'),
    (Node: 'DD_IMAGEBG'; Children: ''),
    (Node: 'DD_MOVE'; Children: 'DDMOVE_HIGHLIGHT,DDMOVE_NOHIGHLIGHT'),
    (Node: 'DD_NONE'; Children: 'DDNONE_HIGHLIGHT,DDNONE_NOHIGHLIGHT'),
    (Node: 'DD_TEXTBG'; Children: ''),
    (Node: 'DD_UPDATEMETADATA'; Children: 'DDUPDATEMETADATA_HIGHLIGHT,DDUPDATEMETADATA_NOHIGHLIGHT'),
    (Node: 'DD_WARNING'; Children: 'DDWARNING_HIGHLIGHT,DDWARNING_NOHIGHLIGHT'),
    (Node: 'EP_BACKGROUND'; Children: 'EBS_ASSIST,EBS_DISABLED,EBS_FOCUSED,EBS_HOT,EBS_NORMAL,EBS_READONLY'),
    (Node: 'EP_BACKGROUNDWITHBORDER'; Children: 'EBWBS_DISABLED,EBWBS_FOCUSED,EBWBS_HOT,EBWBS_NORMAL'),
    (Node: 'EP_CARET'; Children: ''),
    (Node: 'EP_EDITBORDER_HSCROLL'; Children: 'EPSH_DISABLED,EPSH_FOCUSED,EPSH_HOT,EPSH_NORMAL'),
    (Node: 'EP_EDITBORDER_HVSCROLL'; Children: 'EPSHV_DISABLED,EPSHV_FOCUSED,EPSHV_HOT,EPSHV_NORMAL'),
    (Node: 'EP_EDITBORDER_NOSCROLL'; Children: 'EPSN_DISABLED,EPSN_FOCUSED,EPSN_HOT,EPSN_NORMAL'),
    (Node: 'EP_EDITBORDER_VSCROLL'; Children: 'EPSV_DISABLED,EPSV_FOCUSED,EPSV_HOT,EPSV_NORMAL'),
    (Node: 'EP_EDITTEXT'; Children: 'ETS_ASSIST,ETS_CUEBANNER,ETS_DISABLED,ETS_FOCUSED,ETS_HOT,ETS_NORMAL,ETS_READONLY,ETS_SELECTED'),
    (Node: 'EP_PASSWORD'; Children: ''),
    (Node: 'EBP_HEADERBACKGROUND'; Children: ''),
    (Node: 'EBP_HEADERCLOSE'; Children: 'EBHC_HOT,EBHC_NORMAL,EBHC_PRESSED'),
    (Node: 'EBP_HEADERPIN'; Children: 'EBHP_HOT,EBHP_NORMAL,EBHP_PRESSED,EBHP_SELECTEDHOT,EBHP_SELECTEDNORMAL,EBHP_SELECTEDPRESSED'),
    (Node: 'EBP_IEBARMENU'; Children: 'EBM_HOT,EBM_NORMAL,EBM_PRESSED'),
    (Node: 'EBP_NORMALGROUPBACKGROUND'; Children: ''),
    (Node: 'EBP_NORMALGROUPCOLLAPSE'; Children: 'EBNGC_HOT,EBNGC_NORMAL,EBNGC_PRESSED'),
    (Node: 'EBP_NORMALGROUPEXPAND'; Children: 'EBNGE_HOT,EBNGE_NORMAL,EBNGE_PRESSED'),
    (Node: 'EBP_NORMALGROUPHEAD'; Children: ''),
    (Node: 'EBP_SPECIALGROUPBACKGROUND'; Children: ''),
    (Node: 'EBP_SPECIALGROUPCOLLAPSE'; Children: 'EBSGC_HOT,EBSGC_NORMAL,EBSGC_PRESSED'),
    (Node: 'EBP_SPECIALGROUPEXPAND'; Children: 'EBSGE_HOT,EBSGE_NORMAL,EBSGE_PRESSED'),
    (Node: 'EBP_SPECIALGROUPHEAD'; Children: ''),
    (Node: 'FLYOUT_BODY'; Children: 'FBS_EMPHASIZED,FBS_NORMAL'),
    (Node: 'FLYOUT_DIVIDER'; Children: ''),
    (Node: 'FLYOUT_HEADER'; Children: ''),
    (Node: 'FLYOUT_LABEL'; Children: 'FLS_DISABLED,FLS_EMPHASIZED,FLS_NORMAL,FLS_SELECTED'),
    (Node: 'FLYOUT_LINK'; Children: 'FLYOUTLINK_HOVER,FLYOUTLINK_NORMAL'),
    (Node: 'FLYOUT_LINKAREA'; Children: ''),
    (Node: 'FLYOUT_LINKHEADER'; Children: 'FLH_HOVER,FLH_NORMAL'),
    (Node: 'FLYOUT_WINDOW'; Children: ''),
    (Node: 'GP_BORDER'; Children: 'BSS_FLAT,BSS_RAISED,BSS_SUNKEN'),
    (Node: 'GP_LINEHORZ'; Children: 'LHS_FLAT,LHS_RAISED,LHS_SUNKEN'),
    (Node: 'GP_LINEVERT'; Children: 'LVS_FLAT,LVS_RAISED,LVS_SUNKEN'),
    (Node: 'HP_HEADERDROPDOWN'; Children: 'HDDS_HOT,HDDS_NORMAL,HDDS_SOFTHOT'),
    (Node: 'HP_HEADERDROPDOWNFILTER'; Children: 'HDDFS_HOT,HDDFS_NORMAL,HDDFS_SOFTHOT'),
    (Node: 'HP_HEADERITEM'; Children: 'HIS_HOT,HIS_ICONHOT,HIS_ICONNORMAL,HIS_ICONPRESSED,HIS_ICONSORTEDHOT,HIS_ICONSORTEDNORMAL,HIS_ICONSORTEDPRESSED,HIS_NORMAL,HIS_PRESSED,HIS_SORTEDNORMAL,HIS_SORTEDHOT,HIS_SORTEDPRESSED'),
    (Node: 'HP_HEADERITEMLEFT'; Children: 'HILS_HOT,HILS_NORMAL,HILS_PRESSED'),
    (Node: 'HP_HEADERITEMRIGHT'; Children: 'HIRS_HOT,HIRS_NORMAL,HIRS_PRESSED'),
    (Node: 'HP_HEADEROVERFLOW'; Children: 'HOFS_HOT,HOFS_NORMAL'),
    (Node: 'HP_HEADERSORTARROW'; Children: 'HSAS_SORTEDDOWN,HSAS_SORTEDUP'),
    (Node: 'LBCP_BORDER_HSCROLL'; Children: 'LBPSH_DISABLED,LBPSH_FOCUSED,LBPSH_HOT,LBPSH_NORMAL'),
    (Node: 'LBCP_BORDER_HVSCROLL'; Children: 'LBPSHV_DISABLED,LBPSHV_FOCUSED,LBPSHV_HOT,LBPSHV_NORMAL'),
    (Node: 'LBCP_BORDER_NOSCROLL'; Children: 'LBPSN_DISABLED,LBPSN_FOCUSED,LBPSN_HOT,LBPSN_NORMAL'),
    (Node: 'LBCP_BORDER_VSCROLL'; Children: 'LBPSV_DISABLED,LBPSV_FOCUSED,LBPSV_HOT,LBPSV_NORMAL'),
    (Node: 'LBCP_ITEM'; Children: 'LBPSI_HOT,LBPSI_HOTSELECTED,LBPSI_SELECTED,LBPSI_SELECTEDNOTFOCUS'),
    (Node: 'LVP_COLLAPSEBUTTON'; Children: 'LVCB_HOVER,LVCB_NORMAL,LVCB_PUSHED'),
    (Node: 'LVP_COLUMNDETAIL'; Children: ''),
    (Node: 'LVP_EMPTYTEXT'; Children: ''),
    (Node: 'LVP_EXPANDBUTTON'; Children: 'LVEB_HOVER,LVEB_NORMAL,LVEB_PUSHED'),
    (Node: 'LVP_GROUPHEADER'; Children: 'LVGH_CLOSE,LVGH_CLOSEHOT,LVGH_CLOSESELECTED,LVGH_CLOSESELECTEDHOT,LVGH_CLOSESELECTEDNOTFOCUSED,LVGH_CLOSESELECTEDNOTFOCUSEDHOT,'+'LVGH_CLOSEMIXEDSELECTION,LVGH_CLOSEMIXEDSELECTIONHOT,LVGH_OPEN,LVGH_OPENHOT,LVGH_OPENSELECTED,LVGH_OPENSELECTEDHOT,LVGH_OPENSELECTEDNOTFOCUSED,LVGH_OPENSELECTEDNOTFOCUSEDHOT,LVGH_OPENMIXEDSELECTION,LVGH_OPENMIXEDSELECTIONHOT'),
    (Node: 'LVP_GROUPHEADERLINE'; Children: 'LVGHL_CLOSE,LVGHL_CLOSEHOT,LVGHL_CLOSESELECTED,LVGHL_CLOSESELECTEDHOT,LVGHL_CLOSESELECTEDNOTFOCUSED,LVGHL_CLOSESELECTEDNOTFOCUSEDHOT,LVGHL_CLOSEMIXEDSELECTION,'+'LVGHL_CLOSEMIXEDSELECTIONHOT,LVGHL_OPEN,LVGHL_OPENHOT,LVGHL_OPENSELECTED,LVGHL_OPENSELECTEDHOT,LVGHL_OPENSELECTEDNOTFOCUSED,LVGHL_OPENSELECTEDNOTFOCUSEDHOT,LVGHL_OPENMIXEDSELECTION,LVGHL_OPENMIXEDSELECTIONHOT'),
    (Node: 'LVP_LISTGROUP'; Children: ''),
    (Node: 'LVP_LISTDETAIL'; Children: ''),
    (Node: 'LVP_LISTITEM'; Children: 'LISS_DISABLED,LISS_HOT,LISS_HOTSELECTED,LISS_NORMAL,LISS_SELECTED,LISS_SELECTEDNOTFOCUS'),
    (Node: 'LVP_LISTSORTEDDETAIL'; Children: ''),
    (Node: 'MENU_BARBACKGROUND'; Children: 'MB_ACTIVE,MB_INACTIVE'),
    (Node: 'MENU_BARITEM'; Children: 'MBI_DISABLED,MBI_DISABLEDHOT,MBI_DISABLEDPUSHED,MBI_HOT,MBI_NORMAL,MBI_PUSHED'),
    (Node: 'MENU_CHEVRON_TMSCHEMA'; Children: ''),
    (Node: 'MENU_MENUBARDROPDOWN_TMSCHEMA'; Children: ''),
    (Node: 'MENU_MENUBARITEM_TMSCHEMA'; Children: ''),
    (Node: 'MENU_MENUDROPDOWN_TMSCHEMA'; Children: ''),
    (Node: 'MENU_MENUITEM_TMSCHEMA'; Children: ''),
    (Node: 'MENU_POPUPBACKGROUND'; Children: ''),
    (Node: 'MENU_POPUPBORDERS'; Children: ''),
    (Node: 'MENU_POPUPCHECK'; Children: 'MC_BULLETDISABLED,MC_BULLETNORMAL,MC_CHECKMARKDISABLED,MC_CHECKMARKNORMAL'),
    (Node: 'MENU_POPUPCHECKBACKGROUND'; Children: 'MCB_BITMAP,MCB_DISABLED,MCB_NORMAL'),
    (Node: 'MENU_POPUPGUTTER'; Children: ''),
    (Node: 'MENU_POPUPITEM'; Children: 'MPI_DISABLED,MPI_DISABLEDHOT,MPI_HOT,MPI_NORMAL'),
    (Node: 'MENU_POPUPSEPARATOR'; Children: ''),
    (Node: 'MENU_POPUPSUBMENU'; Children: 'MSM_DISABLED,MSM_NORMAL'),
    (Node: 'MENU_SEPARATOR_TMSCHEMA'; Children: ''),
    (Node: 'MENU_SYSTEMCLOSE'; Children: 'MSYSC_DISABLED,MSYSC_NORMAL'),
    (Node: 'MENU_SYSTEMMAXIMIZE'; Children: 'MSYSMX_DISABLED,MSYSMX_NORMAL'),
    (Node: 'MENU_SYSTEMMINIMIZE'; Children: 'MSYSMN_DISABLED,MSYSMN_NORMAL'),
    (Node: 'MENU_SYSTEMRESTORE'; Children: 'MSYSR_DISABLED,MSYSR_NORMAL'),
    (Node: 'MDP_NEWAPPBUTTON'; Children: 'MDS_CHECKED,MDS_DISABLED,MDS_HOT,MDS_HOTCHECKED,MDS_NORMAL,MDS_PRESSED'),
    (Node: 'MDP_SEPERATOR'; Children: ''),
    (Node: 'NAV_BACKBUTTON'; Children: 'NAV_BB_DISABLED,NAV_BB_HOT,NAV_BB_NORMAL,NAV_BB_PRESSED'),
    (Node: 'NAV_FORWARDBUTTON'; Children: 'NAV_FB_DISABLED,NAV_FB_HOT,NAV_FB_NORMAL,NAV_FB_PRESSED'),
    (Node: 'NAV_MENUBUTTON'; Children: 'NAV_MB_DISABLED,NAV_MB_HOT,NAV_MB_NORMAL,NAV_MB_PRESSED'),
    (Node: 'PGRP_DOWN'; Children: 'DNS_DISABLED,DNS_HOT,DNS_NORMAL,DNS_PRESSED'),
    (Node: 'PGRP_DOWNHORZ'; Children: 'DNHZS_DISABLED,DNHZS_HOT,DNHZS_NORMAL,DNHZS_PRESSED'),
    (Node: 'PGRP_UP'; Children: 'UPS_DISABLED,UPS_HOT,UPS_NORMAL,UPS_PRESSED'),
    (Node: 'PGRP_UPHORZ'; Children: 'UPHZS_DISABLED,UPHZS_HOT,UPHZS_NORMAL,UPHZS_PRESSED'),
    (Node: 'PP_BAR'; Children: ''),
    (Node: 'PP_BARVERT'; Children: ''),
    (Node: 'PP_CHUNK'; Children: ''),
    (Node: 'PP_CHUNKVERT'; Children: ''),
    (Node: 'PP_FILL'; Children: 'PBFS_ERROR,PBFS_NORMAL,PBFS_PARTIAL,PBFS_PAUSED'),
    (Node: 'PP_FILLVERT'; Children: 'PBFVS_ERROR,PBFVS_NORMAL,PBFVS_PARTIAL,PBFVS_PAUSED'),
    (Node: 'PP_MOVEOVERLAY'; Children: ''),
    (Node: 'PP_MOVEOVERLAYVERT'; Children: ''),
    (Node: 'PP_PULSEOVERLAY'; Children: ''),
    (Node: 'PP_PULSEOVERLAYVERT'; Children: ''),
    (Node: 'PP_TRANSPARENTBAR'; Children: 'PBBS_NORMAL,PBBS_PARTIAL'),
    (Node: 'PP_TRANSPARENTBARVERT'; Children: 'PBBVS_NORMAL,PBBVS_PARTIAL'),
    (Node: 'RP_BACKGROUND'; Children: ''),
    (Node: 'RP_BAND'; Children: ''),
    (Node: 'RP_CHEVRON'; Children: 'CHEVS_HOT,CHEVS_NORMAL,CHEVS_PRESSED'),
    (Node: 'RP_CHEVRONVERT'; Children: 'CHEVSV_HOT,CHEVSV_NORMAL,CHEVSV_PRESSED'),
    (Node: 'RP_GRIPPER'; Children: ''),
    (Node: 'RP_GRIPPERVERT'; Children: ''),
    (Node: 'RP_SPLITTER'; Children: 'SPLITS_HOT,SPLITS_NORMAL,SPLITS_PRESSED'),
    (Node: 'RP_SPLITTERVERT'; Children: 'SPLITSV_HOT,SPLITSV_NORMAL,SPLITSV_PRESSED'),
    (Node: 'SBP_ARROWBTN'; Children: 'ABS_DOWNDISABLED,ABS_DOWNHOT,ABS_DOWNNORMAL,ABS_DOWNPRESSED,ABS_DOWNHOVER,ABS_LEFTDISABLED,ABS_LEFTHOT,ABS_LEFTHOVER,ABS_LEFTNORMAL,ABS_LEFTPRESSED,'+'ABS_RIGHTDISABLED,ABS_RIGHTHOT,ABS_RIGHTHOVER,ABS_RIGHTNORMAL,ABS_RIGHTPRESSED,ABS_UPDISABLED,ABS_UPHOT,ABS_UPHOVER,ABS_UPNORMAL,ABS_UPPRESSED'),
    (Node: 'SBP_GRIPPERHORZ'; Children: 'SCRBS_DISABLED,SCRBS_HOT,SCRBS_HOVER,SCRBS_NORMAL,SCRBS_PRESSED'),
    (Node: 'SBP_GRIPPERVERT'; Children: 'SCRBS_DISABLED,SCRBS_HOT,SCRBS_HOVER,SCRBS_NORMAL,SCRBS_PRESSED'),
    (Node: 'SBP_LOWERTRACKHORZ'; Children: 'SCRBS_DISABLED,SCRBS_HOT,SCRBS_HOVER,SCRBS_NORMAL,SCRBS_PRESSED'),
    (Node: 'SBP_LOWERTRACKVERT'; Children: 'SCRBS_DISABLED,SCRBS_HOT,SCRBS_HOVER,SCRBS_NORMAL,SCRBS_PRESSED'),
    (Node: 'SBP_SIZEBOX'; Children: 'SZB_HALFBOTTOMRIGHTALIGN,SZB_HALFBOTTOMLEFTALIGN,SZB_HALFTOPRIGHTALIGN,SZB_HALFTOPLEFTALIGN,SZB_LEFTALIGN,SZB_RIGHTALIGN,SZB_TOPRIGHTALIGN,SZB_TOPLEFTALIGN'),
    (Node: 'SBP_THUMBBTNHORZ'; Children: 'SCRBS_DISABLED,SCRBS_HOT,SCRBS_HOVER,SCRBS_NORMAL,SCRBS_PRESSED'),
    (Node: 'SBP_THUMBBTNVERT'; Children: 'SCRBS_DISABLED,SCRBS_HOT,SCRBS_HOVER,SCRBS_NORMAL,SCRBS_PRESSED'),
    (Node: 'SBP_UPPERTRACKHORZ'; Children: 'SCRBS_DISABLED,SCRBS_HOT,SCRBS_HOVER,SCRBS_NORMAL,SCRBS_PRESSED'),
    (Node: 'SBP_UPPERTRACKVERT'; Children: 'SCRBS_DISABLED,SCRBS_HOT,SCRBS_HOVER,SCRBS_NORMAL,SCRBS_PRESSED'),
    (Node: 'SEBP_SEARCHEDITBOXTEXT'; Children: 'SEBTS_FORMATTED'),
    (Node: 'SPNP_DOWN'; Children: 'DNS_DISABLED,DNS_HOT,DNS_NORMAL,DNS_PRESSED'),
    (Node: 'SPNP_DOWNHORZ'; Children: 'DNHZS_DISABLED,DNHZS_HOT,DNHZS_NORMAL,DNHZS_PRESSED'),
    (Node: 'SPNP_UP'; Children: 'UPS_DISABLED,UPS_HOT,UPS_NORMAL,UPS_PRESSED'),
    (Node: 'SPNP_UPHORZ'; Children: 'UPHZS_DISABLED,UPHZS_HOT,UPHZS_NORMAL,UPHZS_PRESSED'),
    (Node: 'SPP_LOGOFF'; Children: ''),
    (Node: 'SPP_LOGOFFBUTTONS'; Children: 'SPLS_HOT,SPLS_NORMAL,SPLS_PRESSED'),
    (Node: 'SPP_MOREPROGRAMS'; Children: ''),
    (Node: 'SPP_MOREPROGRAMSARROW'; Children: 'SPS_HOT,SPS_NORMAL,SPS_PRESSED'),
    (Node: 'SPP_PLACESLIST'; Children: ''),
    (Node: 'SPP_PLACESLISTSEPARATOR'; Children: ''),
    (Node: 'SPP_PREVIEW'; Children: ''),
    (Node: 'SPP_PROGLIST'; Children: ''),
    (Node: 'SPP_PROGLISTSEPARATOR'; Children: ''),
    (Node: 'SPP_USERPANE'; Children: ''),
    (Node: 'SPP_USERPICTURE'; Children: ''),
    (Node: 'SP_GRIPPER'; Children: ''),
    (Node: 'SP_GRIPPERPANE'; Children: ''),
    (Node: 'SP_PANE'; Children: ''),
    (Node: 'TABP_AEROWIZARDBODY'; Children: ''),
    (Node: 'TABP_BODY'; Children: ''),
    (Node: 'TABP_PANE'; Children: ''),
    (Node: 'TABP_TABITEM'; Children: 'TIS_DISABLED,TIS_FOCUSED,TIS_HOT,TIS_NORMAL,TIS_SELECTED'),
    (Node: 'TABP_TABITEMBOTHEDGE'; Children: 'TIBES_DISABLED,TIBES_FOCUSED,TIBES_HOT,TIBES_NORMAL,TIBES_SELECTED'),
    (Node: 'TABP_TABITEMLEFTEDGE'; Children: 'TILES_DISABLED,TILES_FOCUSED,TILES_HOT,TILES_NORMAL,TILES_SELECTED'),
    (Node: 'TABP_TABITEMRIGHTEDGE'; Children: 'TIRES_DISABLED,TIRES_FOCUSED,TIRES_HOT,TIRES_NORMAL,TIRES_SELECTED'),
    (Node: 'TABP_TOPTABITEM'; Children: 'TTIS_DISABLED,TTIS_FOCUSED,TTIS_HOT,TTIS_NORMAL,TTIS_SELECTED'),
    (Node: 'TABP_TOPTABITEMBOTHEDGE'; Children: 'TTIBES_DISABLED,TTIBES_FOCUSED,TTIBES_HOT,TTIBES_NORMAL,TTIBES_SELECTED'),
    (Node: 'TABP_TOPTABITEMLEFTEDGE'; Children: 'TTILES_DISABLED,TTILES_FOCUSED,TTILES_HOT,TTILES_NORMAL,TTILES_SELECTED'),
    (Node: 'TABP_TOPTABITEMRIGHTEDGE'; Children: 'TTIRES_DISABLED,TTIRES_FOCUSED,TTIRES_HOT,TTIRES_NORMAL,TTIRES_SELECTED'),
    (Node: 'TDP_GROUPCOUNT'; Children: ''),
    (Node: 'TDP_FLASHBUTTON'; Children: ''),
    (Node: 'TDP_FLASHBUTTONGROUPMENU'; Children: ''),
    (Node: 'TBP_BACKGROUNDBOTTOM'; Children: ''),
    (Node: 'TBP_BACKGROUNDLEFT'; Children: ''),
    (Node: 'TBP_BACKGROUNDRIGHT'; Children: ''),
    (Node: 'TBP_BACKGROUNDTOP'; Children: ''),
    (Node: 'TBP_SIZINGBARBOTTOM'; Children: ''),
    (Node: 'TBP_SIZINGBARBOTTOMLEFT'; Children: ''),
    (Node: 'TBP_SIZINGBARRIGHT'; Children: ''),
    (Node: 'TBP_SIZINGBARTOP'; Children: ''),
    (Node: 'TDLG_BUTTONSECTION'; Children: ''),
    (Node: 'TDLG_BUTTONWRAPPER'; Children: ''),
    (Node: 'TDLG_COMMANDLINKPANE'; Children: ''),
    (Node: 'TDLG_CONTENTICON'; Children: ''),
    (Node: 'TDLG_CONTENTPANE'; Children: 'TDLGCPS_STANDALONE'),
    (Node: 'TDLG_CONTROLPANE'; Children: ''),
    (Node: 'TDLG_EXPANDEDCONTENT'; Children: ''),
    (Node: 'TDLG_EXPANDEDFOOTERAREA'; Children: ''),
    (Node: 'TDLG_EXPANDOBUTTON'; Children: 'TDLGEBS_EXPANDEDHOVER,TDLGEBS_EXPANDEDNORMAL,TDLGEBS_EXPANDEDPRESSED,TDLGEBS_HOVER,TDLGEBS_NORMAL,TDLGEBS_PRESSED'),
    (Node: 'TDLG_EXPANDOTEXT'; Children: ''),
    (Node: 'TDLG_FOOTNOTEAREA'; Children: ''),
    (Node: 'TDLG_FOOTNOTEPANE'; Children: ''),
    (Node: 'TDLG_FOOTNOTESEPARATOR'; Children: ''),
    (Node: 'TDLG_IMAGEALIGNMENT'; Children: ''),
    (Node: 'TDLG_MAINICON'; Children: ''),
    (Node: 'TDLG_MAININSTRUCTIONPANE'; Children: ''),
    (Node: 'TDLG_PRIMARYPANEL'; Children: ''),
    (Node: 'TDLG_PROGRESSBAR'; Children: ''),
    (Node: 'TDLG_RADIOBUTTONPANE'; Children: ''),
    (Node: 'TDLG_SECONDARYPANEL'; Children: ''),
    (Node: 'TDLG_VERIFICATIONTEXT'; Children: ''),
    (Node: 'TEXT_BODYTITLE'; Children: ''),
    (Node: 'TEXT_BODYTEXT'; Children: ''),
    (Node: 'TEXT_CONTROLLABEL'; Children: 'TS_CONTROLLABEL_DISABLED,TS_CONTROLLABEL_NORMAL'),
    (Node: 'TEXT_EXPANDED'; Children: ''),
    (Node: 'TEXT_HYPERLINKTEXT'; Children: 'TS_HYPERLINK_DISABLED,TS_HYPERLINK_HOT,TS_HYPERLINK_NORMAL,TS_HYPERLINK_PRESSED'),
    (Node: 'TEXT_INSTRUCTION'; Children: ''),
    (Node: 'TEXT_LABEL'; Children: ''),
    (Node: 'TEXT_MAININSTRUCTION'; Children: ''),
    (Node: 'TEXT_SECONDARYTEXT'; Children: ''),
    (Node: 'TP_BUTTON'; Children: 'TS_CHECKED,TS_DISABLED,TS_HOT,TS_HOTCHECKED,TS_NEARHOT,TS_NORMAL,TS_OTHERSIDEHOT,TS_PRESSED'),
    (Node: 'TP_DROPDOWNBUTTON'; Children: 'TS_CHECKED,TS_DISABLED,TS_HOT,TS_HOTCHECKED,TS_NEARHOT,TS_NORMAL,TS_OTHERSIDEHOT,TS_PRESSED'),
    (Node: 'TP_DROPDOWNBUTTONGLYPH'; Children: 'TS_CHECKED,TS_DISABLED,TS_HOT,TS_HOTCHECKED,TS_NEARHOT,TS_NORMAL,TS_OTHERSIDEHOT,TS_PRESSED'),
    (Node: 'TP_SEPARATOR'; Children: 'TS_CHECKED,TS_DISABLED,TS_HOT,TS_HOTCHECKED,TS_NEARHOT,TS_NORMAL,TS_OTHERSIDEHOT,TS_PRESSED'),
    (Node: 'TP_SEPARATORVERT'; Children: 'TS_CHECKED,TS_DISABLED,TS_HOT,TS_HOTCHECKED,TS_NEARHOT,TS_NORMAL,TS_OTHERSIDEHOT,TS_PRESSED'),
    (Node: 'TP_SPLITBUTTON'; Children: 'TS_CHECKED,TS_DISABLED,TS_HOT,TS_HOTCHECKED,TS_NEARHOT,TS_NORMAL,TS_OTHERSIDEHOT,TS_PRESSED'),
    (Node: 'TP_SPLITBUTTONDROPDOWN'; Children: 'TS_CHECKED,TS_DISABLED,TS_HOT,TS_HOTCHECKED,TS_NEARHOT,TS_NORMAL,TS_OTHERSIDEHOT,TS_PRESSED'),
    (Node: 'TTP_BALLOON'; Children: 'TTBS_LINK,TTBS_NORMAL'),
    (Node: 'TTP_BALLOONSTEM'; Children: 'TTBSS_POINTINGUPLEFTWALL,TTBSS_POINTINGUPCENTERED,TTBSS_POINTINGUPRIGHTWALL,TTBSS_POINTINGDOWNRIGHTWALL,TTBSS_POINTINGDOWNCENTERED,TTBSS_POINTINGDOWNLEFTWALL'),
    (Node: 'TTP_BALLOONTITLE'; Children: ''),
    (Node: 'TTP_CLOSE'; Children: 'TTCS_HOT,TTCS_NORMAL,TTCS_PRESSED'),
    (Node: 'TTP_STANDARD'; Children: 'TTSS_LINK,TTSS_NORMAL'),
    (Node: 'TTP_STANDARDTITLE'; Children: 'TTSS_LINK,TTSS_NORMAL'),
    (Node: 'TTP_WRENCH'; Children: 'TTWS_NORMAL,TTWS_HOT,TTWS_PRESSED'),
    (Node: 'TKP_THUMB'; Children: 'TUS_DISABLED,TUS_FOCUSED,TUS_HOT,TUS_NORMAL,TUS_PRESSED'),
    (Node: 'TKP_THUMBBOTTOM'; Children: 'TUBS_DISABLED,TUBS_FOCUSED,TUBS_HOT,TUBS_NORMAL,TUBS_PRESSED'),
    (Node: 'TKP_THUMBLEFT'; Children: 'TUVLS_DISABLED,TUVLS_FOCUSED,TUVLS_HOT,TUVLS_NORMAL,TUVLS_PRESSED'),
    (Node: 'TKP_THUMBRIGHT'; Children: 'TUVRS_DISABLED,TUVRS_FOCUSED,TUVRS_HOT,TUVRS_NORMAL,TUVRS_PRESSED'),
    (Node: 'TKP_THUMBTOP'; Children: 'TUTS_DISABLED,TUTS_FOCUSED,TUTS_HOT,TUTS_NORMAL,TUTS_PRESSED'),
    (Node: 'TKP_THUMBVERT'; Children: 'TUVS_DISABLED,TUVS_FOCUSED,TUVS_HOT,TUVS_NORMAL,TUVS_PRESSED'),
    (Node: 'TKP_TICS'; Children: 'TSS_NORMAL'),
    (Node: 'TKP_TICSVERT'; Children: 'TSVS_NORMAL'),
    (Node: 'TKP_TRACK'; Children: 'TRS_NORMAL'),
    (Node: 'TKP_TRACKVERT'; Children: 'TRVS_NORMAL'),
    (Node: 'TNP_ANIMBACKGROUND'; Children: ''),
    (Node: 'TNP_BACKGROUND'; Children: ''),
    (Node: 'TVP_BRANCH'; Children: ''),
    (Node: 'TVP_GLYPH'; Children: 'GLPS_CLOSED,GLPS_OPENED'),
    (Node: 'TVP_HOTGLYPH'; Children: 'HGLPS_CLOSED,HGLPS_OPENED'),
    (Node: 'TVP_TREEITEM'; Children: 'TREIS_DISABLED,TREIS_HOT,TREIS_NORMAL,TREIS_SELECTED,TREIS_SELECTEDNOTFOCUS,TREIS_HOTSELECTED'),
    (Node: 'WP_CAPTION'; Children: 'CS_ACTIVE,CS_DISABLED,CS_INACTIVE'),
    (Node: 'WP_CAPTIONSIZINGTEMPLATE'; Children: ''),
    (Node: 'WP_CLOSEBUTTON'; Children: 'CBS_DISABLED,CBS_HOT,CBS_NORMAL,CBS_PUSHED'),
    (Node: 'WP_DIALOG'; Children: ''),
    (Node: 'WP_FRAME'; Children: 'FS_ACTIVE,FS_INACTIVE'),
    (Node: 'WP_FRAMEBOTTOM'; Children: ''),
    (Node: 'WP_FRAMEBOTTOMSIZINGTEMPLATE'; Children: ''),
    (Node: 'WP_FRAMELEFT'; Children: ''),
    (Node: 'WP_FRAMELEFTSIZINGTEMPLATE'; Children: ''),
    (Node: 'WP_FRAMERIGHT'; Children: ''),
    (Node: 'WP_FRAMERIGHTSIZINGTEMPLATE'; Children: ''),
    (Node: 'WP_HELPBUTTON'; Children: 'HBS_DISABLED,HBS_HOT,HBS_NORMAL,HBS_PUSHED'),
    (Node: 'WP_HORZSCROLL'; Children: 'HSS_DISABLED,HSS_HOT,HSS_NORMAL,HSS_PUSHED'),
    (Node: 'WP_HORZTHUMB'; Children: 'HTS_DISABLED,HTS_HOT,HTS_NORMAL,HTS_PUSHED'),
    (Node: 'WP_MAXBUTTON'; Children: 'MAXBS_DISABLED,MAXBS_HOT,MAXBS_NORMAL,MAXBS_PUSHED'),
    (Node: 'WP_MAXCAPTION'; Children: 'MXCS_ACTIVE,MXCS_DISABLED,MXCS_INACTIVE'),
    (Node: 'WP_MDICLOSEBUTTON'; Children: ''),
    (Node: 'WP_MDIHELPBUTTON'; Children: ''),
    (Node: 'WP_MDIMINBUTTON'; Children: ''),
    (Node: 'WP_MDIRESTOREBUTTON'; Children: ''),
    (Node: 'WP_MDISYSBUTTON'; Children: ''),
    (Node: 'WP_MINBUTTON'; Children: 'MINBS_DISABLED,MINBS_HOT,MINBS_NORMAL,MINBS_PUSHED'),
    (Node: 'WP_MINCAPTION'; Children: 'MNCS_ACTIVE,MNCS_DISABLED,MNCS_INACTIVE'),
    (Node: 'WP_RESTOREBUTTON'; Children: 'RBS_DISABLED,RBS_HOT,RBS_NORMAL,RBS_PUSHED'),
    (Node: 'WP_SMALLCAPTION'; Children: ''),
    (Node: 'WP_SMALLCAPTIONSIZINGTEMPLATE'; Children: ''),
    (Node: 'WP_SMALLCLOSEBUTTON'; Children: ''),
    (Node: 'WP_SMALLFRAMEBOTTOM'; Children: ''),
    (Node: 'WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE'; Children: ''),
    (Node: 'WP_SMALLFRAMELEFT'; Children: ''),
    (Node: 'WP_SMALLFRAMELEFTSIZINGTEMPLATE'; Children: ''),
    (Node: 'WP_SMALLFRAMERIGHT'; Children: ''),
    (Node: 'WP_SMALLFRAMERIGHTSIZINGTEMPLATE'; Children: ''),
    (Node: 'WP_SMALLMAXCAPTION'; Children: ''),
    (Node: 'WP_SMALLMINCAPTION'; Children: ''),
    (Node: 'WP_SYSBUTTON'; Children: 'SBS_DISABLED,SBS_HOT,SBS_NORMAL,SBS_PUSHED'),
    (Node: 'WP_VERTSCROLL'; Children: 'VSS_DISABLED,VSS_HOT,VSS_NORMAL,VSS_PUSHED'),
    (Node: 'WP_VERTTHUMB'; Children: 'VTS_DISABLED,VTS_HOT,VTS_NORMAL,VTS_PUSHED'));


function ParseIdent(const Ident: string): integer;
function GetParts(const UxClass: string): StringArray;
function GetStates(const Part: string): StringArray;

implementation

function SplitAndTrim(const str: string; const delim: char): StringArray;
var
  SepPos: IntegerArray;
  i: Integer;
begin
  SetLength(SepPos, 1);
  SepPos[0] := 0;
  for i := 1 to length(str) do
    if str[i] = delim then
    begin
      SetLength(SepPos, length(SepPos) + 1);
      SepPos[high(SepPos)] := i;
    end;
  SetLength(SepPos, length(SepPos) + 1);
  SepPos[high(SepPos)] := length(str) + 1;
  SetLength(result, high(SepPos));
  for i := 0 to high(SepPos) -  1 do
    result[i] := Trim(Copy(str, SepPos[i] + 1, SepPos[i+1] - SepPos[i] - 1));
end;

function SplitAndTrimEx(const str: string; const delim: char): StringArray;
begin
  result := SplitAndTrim(str, delim);
  if (length(result) = 1) and (length(result[0]) = 0) then
    result := nil;
end;

function ParseIdent(const Ident: string): integer;
var
  i: Integer;
begin
  for i := 0 to high(ConstantDirectory) do
    if SameStr(Ident, ConstantDirectory[i].Ident) then
      Exit(ConstantDirectory[i].Value);
  raise Exception.CreateFmt('There is no constant named "%s".', [Ident]);
end;

function GetParts(const UxClass: string): StringArray;
var
  i: Integer;
begin
  for i := 0 to high(ClassesWithParts) do
    if SameStr(UxClass, ClassesWithParts[i].Node) then
      Exit(SplitAndTrimEx(ClassesWithParts[i].Children, ','));
  raise Exception.CreateFmt('There is no class named "%s".', [UxClass]);
end;

function GetStates(const Part: string): StringArray;
var
  i: Integer;
begin
  for i := 0 to high(PartsWithStates) do
    if SameStr(Part, PartsWithStates[i].Node) then
      Exit(SplitAndTrimEx(PartsWithStates[i].Children, ','));
  raise Exception.CreateFmt('There is no part named "%s".', [Part]);
end;

end.
