package com.example.permissiontest;

import java.util.HashMap;
import android.hardware.usb.UsbDevice;
import java.util.Iterator;

import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.app.Activity;
import android.app.Service;
import android.content.Context;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class MainActivity extends Activity
{
	
	private EditText txtBox;
	private Button btnRefresh;
	
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		txtBox = (EditText) findViewById(R.id.editText1);
		btnRefresh = (Button) findViewById(R.id.button1);
		
		btnRefresh.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View arg0)
			{
				refreshDevices();
				
			}
		});
	}
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		getMenuInflater().inflate(R.menu.activity_main, menu);
		return true;
	}
	
	private void refreshDevices()
	{
		UsbManager manager = (UsbManager) getSystemService(Context.USB_SERVICE);
		// Get the list of attached devices
		HashMap<String, UsbDevice> devices = manager.getDeviceList();
		
		txtBox.setText("");
		txtBox.setText("Number of devices: " + devices.size() + "\n");
		
		// Iterate over all devices
		Iterator<String> it = devices.keySet().iterator();
		while (it.hasNext())
		{
			String deviceName = it.next();
			UsbDevice device = devices.get(deviceName);
			
			String VID = Integer.toHexString(device.getVendorId()).toUpperCase();
			String PID = Integer.toHexString(device.getProductId()).toUpperCase();
			txtBox.append(deviceName + " " +  VID + ":" + PID + " " + manager.hasPermission(device) + "\n");
		}
	}
	
}
