@echo off

rem 
rem  Skip first lines & tail last lines for MS DOS
rem           2015 (c) Robert Harchut
rem  
rem  This is a native shellscript to remove the 
rem  leading and last lines of a flat text file 
rem  under MS DOS console without any additional utilites.
rem  
rem  http://harchut.de/ms-dos/skip-tail-flatfile-example.bat
rem  

goto G_START

rem ==========  NATIVE MS DOS SKIP & TAIL FUNCTION ==========

:G_TRIMFILE

rem set P_TRIMFILE_INFILE  = input filename (e.g. input.txt)
rem set P_TRIMFILE_OUTFILE = output filename (e.g. output.txt)
rem set P_TRIMFILE_SKIP    = irgnore leading lines (e.g. 5)
rem set P_TRIMFILE_TAIL    = irgnore last lines (e.g. 3)
rem set P_TRIMFILE_ONEXIT  = jump label (e.g. G_TRIMFILE_END1)

echo *** 0. INPUT FILE ***
echo P_TRIMFILE_INFILE  = %P_TRIMFILE_INFILE%
echo P_TRIMFILE_OUTFILE = %P_TRIMFILE_OUTFILE%
echo P_TRIMFILE_SKIP    = %P_TRIMFILE_SKIP%
echo P_TRIMFILE_TAIL    = %P_TRIMFILE_TAIL% 
echo P_TRIMFILE_ONEXIT  = %P_TRIMFILE_ONEXIT%
echo.
type %P_TRIMFILE_INFILE%
echo.

rem ---  count number of rows : find /c /v "" ...
set L_TRIMFILE_CNT=0
set L_TRIMFILE_TMPFILE=work.countrows.find.tmp
find /c /v "" %P_TRIMFILE_INFILE% > %L_TRIMFILE_TMPFILE%
echo *** 1. COUNT LINES ***
type %L_TRIMFILE_TMPFILE%
echo.

rem ---  parse number of rows : for /f "..." %%a in (...)
for /f "skip=1 tokens=3* " %%a in (%L_TRIMFILE_TMPFILE%) do (
  if %L_TRIMFILE_CNT% == 0 set L_TRIMFILE_CNT=%%a
)
echo *** 2. PARSE LINES ***
echo "%L_TRIMFILE_CNT%" rows at file "%P_TRIMFILE_INFILE%"
echo.
del %L_TRIMFILE_TMPFILE%

rem ---  calculate the tail linenumber : set /a ...
echo *** 3. CALCULATE TAIL LINE ***
set /a L_TRIMFILE_EOF=%L_TRIMFILE_CNT%-%P_TRIMFILE_TAIL%
echo "%L_TRIMFILE_EOF%" tail line at file "%P_TRIMFILE_INFILE%"
echo.

rem ---  enumerate each line : findstr /n .* ...
findstr /n .* "%P_TRIMFILE_INFILE%" > %L_TRIMFILE_TMPFILE%
echo *** 4. ENUMAERATE LINES ***
type %L_TRIMFILE_TMPFILE%
echo.

rem ---  skip and tail lines : for /f "skip=..." & if linenum < tailline
if exist %P_TRIMFILE_OUTFILE% del %P_TRIMFILE_OUTFILE%
echo *** 5. SKIP AND TAIL FILE ***
set V_TRIMFILE_SKIP="skip=%P_TRIMFILE_SKIP% tokens=1* delims=:"
if %P_TRIMFILE_SKIP% equ 0 set V_TRIMFILE_SKIP="tokens=1* delims=:"
for /f %V_TRIMFILE_SKIP% %%a in (%L_TRIMFILE_TMPFILE%) do (
  if %%a leq %L_TRIMFILE_EOF% if exist %P_TRIMFILE_OUTFILE%     echo append file and write line %%a : %%b
  if %%a leq %L_TRIMFILE_EOF% if not exist %P_TRIMFILE_OUTFILE% echo create file and write line %%a : %%b
  if %%a leq %L_TRIMFILE_EOF% if exist %P_TRIMFILE_OUTFILE% @echo.%%b>>%P_TRIMFILE_OUTFILE%
  if %%a leq %L_TRIMFILE_EOF% if not exist %P_TRIMFILE_OUTFILE% @echo.%%b>%P_TRIMFILE_OUTFILE%
)
del %L_TRIMFILE_TMPFILE%
echo.

rem ---  jump back to source : dirty coding
echo *** 6. OUTPUT FILE ***
type %P_TRIMFILE_OUTFILE%
echo.
goto %P_TRIMFILE_ONEXIT%

rem =======================  WORKFLOW  ======================

:G_START

rem ---  create a example input file
set V_MAKEINPUT=skip-tail-flatfile-example.input.txt
if exist %V_MAKEINPUT% del %V_MAKEINPUT%
echo Line-1 >%V_MAKEINPUT%
echo Line-2 >>%V_MAKEINPUT%
echo Line-3 >>%V_MAKEINPUT%
echo Line-4 >>%V_MAKEINPUT%
echo Line-5 >>%V_MAKEINPUT%
echo Line-6 >>%V_MAKEINPUT%

rem ---  skip and tail lines
set P_TRIMFILE_INFILE=skip-tail-flatfile-example.input.txt
set P_TRIMFILE_OUTFILE=skip-tail-flatfile-example.output-1.txt
set P_TRIMFILE_SKIP=2
set P_TRIMFILE_TAIL=2
set P_TRIMFILE_ONEXIT=G_TRIMFILE_END1
goto G_TRIMFILE
:G_TRIMFILE_END1

rem ---  skip and tail lines
set P_TRIMFILE_OUTFILE=skip-tail-flatfile-example.output-2.txt
set P_TRIMFILE_SKIP=0
set P_TRIMFILE_TAIL=0
set P_TRIMFILE_ONEXIT=G_TRIMFILE_END2
goto G_TRIMFILE
:G_TRIMFILE_END2

rem ---  skip and tail lines
set P_TRIMFILE_OUTFILE=skip-tail-flatfile-example.output-3.txt
set P_TRIMFILE_SKIP=1
set P_TRIMFILE_TAIL=0
set P_TRIMFILE_ONEXIT=G_TRIMFILE_END3
goto G_TRIMFILE
:G_TRIMFILE_END3

rem ---  skip and tail lines
set P_TRIMFILE_OUTFILE=skip-tail-flatfile-example.output-4.txt
set P_TRIMFILE_SKIP=0
set P_TRIMFILE_TAIL=1
set P_TRIMFILE_ONEXIT=G_TRIMFILE_END4
goto G_TRIMFILE
:G_TRIMFILE_END4

pause